/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.dbtools.extension.apex.exceptions.ApexQueryException;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.extension.apex.utility.QueryUtils;

public class APEXLangManifestGenerator {
    protected static final String dummyApexVersion = "25.1.0";
    protected static final String dummyApiVersion = "2099.99.99";
    protected static final BigDecimal dummyAppId = BigDecimal.valueOf(100L);
    protected static final BigDecimal dummyOffset = BigDecimal.valueOf(0L);
    protected static final String dummyDefaultOwner = "MY_SCHEMA";
    protected static final BigDecimal dummyWsId = BigDecimal.valueOf(90000L);
    private String apexVersion;
    private String apiVersion;
    private BigDecimal applicationId;
    private BigDecimal offset;
    private String defaultOwner;
    private BigDecimal workspaceId;

    public APEXLangManifestObject generate() {
        APEXLangManifestObject manifest = new APEXLangManifestObject();
        manifest.setApex_version(this.apexVersion != null ? this.apexVersion : dummyApexVersion);
        manifest.setApi_version(this.apiVersion != null ? this.apiVersion : dummyApiVersion);
        manifest.setApp_id(this.applicationId != null ? this.applicationId.toString() : dummyAppId.toString());
        manifest.setDefault_id_offset(this.offset != null ? this.offset.toString() : dummyOffset.toString());
        manifest.setDefault_owner(this.defaultOwner != null ? this.defaultOwner : dummyDefaultOwner);
        manifest.setWorkspace_id(this.workspaceId != null ? this.workspaceId.toString() : dummyWsId.toString());
        return manifest;
    }

    private APEXLangManifestGenerator(Builder builder) {
        this.workspaceId = builder.workspaceId;
        this.applicationId = builder.applicationId;
        this.offset = builder.offset;
        this.apexVersion = builder.apexVersion;
        this.apiVersion = builder.apiVersion;
        this.defaultOwner = builder.defaultOwner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apexVersion;
        private String apiVersion;
        private BigDecimal applicationId;
        private BigDecimal offset;
        private String defaultOwner;
        private BigDecimal workspaceId;

        public APEXLangManifestGenerator build() {
            return new APEXLangManifestGenerator(this);
        }

        public Builder workspaceId(BigDecimal workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder applicationId(BigDecimal applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder apexVersion(String apexVersion) {
            this.apexVersion = apexVersion;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder offset(BigDecimal offset) {
            this.offset = offset;
            return this;
        }

        public Builder defaultOwner(String defaultOwner) {
            this.defaultOwner = defaultOwner;
            return this;
        }

        public Builder setFromConnection(Connection connection) throws AppNotInstalledException, SQLException, ApexQueryException {
            if (this.apexVersion == null) {
                String string = this.apexVersion = ApexUtil._version.isEmpty() ? ApexUtil.getApexVersion(connection) : ApexUtil._version;
            }
            if (this.apiVersion == null) {
                this.apiVersion = QueryUtils.getAPEXApiVersion(connection);
            }
            if (this.applicationId == null) {
                this.applicationId = QueryUtils.generateApplicationId(connection);
            }
            if (this.offset == null) {
                this.offset = QueryUtils.generateOffset(connection);
            }
            if (this.defaultOwner == null) {
                this.defaultOwner = QueryUtils.getSchema(connection);
            }
            if (this.workspaceId == null) {
                this.workspaceId = QueryUtils.getWorkspaceId(connection);
            }
            return this;
        }
    }
}

