/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.net.URI;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangRange;

public class APEXLangFileUpdate {
    private final URI uri;
    private final Integer version;
    private final UpdateType updateType;
    private final APEXLangRange range;
    private final String text;
    private final URI newUri;

    private APEXLangFileUpdate(Builder builder) {
        this.uri = builder.uri;
        this.version = builder.version;
        this.updateType = builder.updateType;
        this.range = builder.range;
        this.text = builder.text;
        this.newUri = builder.newUri;
    }

    public URI uri() {
        return this.uri;
    }

    public Integer version() {
        return this.version;
    }

    public UpdateType updateType() {
        return this.updateType;
    }

    public APEXLangRange range() {
        return this.range;
    }

    public String text() {
        return this.text;
    }

    public URI newUri() {
        return this.newUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private URI uri;
        private Integer version;
        private UpdateType updateType;
        private APEXLangRange range;
        private String text;
        private URI newUri;

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder updateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        public Builder range(APEXLangRange range) {
            this.range = range;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder newUri(URI newUri) {
            this.newUri = newUri;
            return this;
        }

        public APEXLangFileUpdate build() {
            return new APEXLangFileUpdate(this);
        }
    }

    public static enum UpdateType {
        EDIT,
        CREATE,
        RENAME,
        DELETE;

    }
}

