/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangRange;

public class APEXLangCompletionItem {
    private final String choice;
    private final int type;
    private final APEXLangRange range;
    private final String detail;
    private final String insertText;
    private final int insertTextFormat;
    private final String sortText;
    private final String commandTitle;
    private final String commandId;
    private final List<Object> commandArgs;

    public APEXLangCompletionItem(Builder builder) {
        this.choice = builder.choice;
        this.type = builder.type;
        this.range = builder.range;
        this.detail = builder.detail;
        this.insertText = builder.insertText != null ? builder.insertText : builder.choice;
        this.insertTextFormat = builder.insertTextFormat != null ? builder.insertTextFormat : 1;
        this.sortText = builder.sortText;
        this.commandTitle = builder.commandTitle;
        this.commandId = builder.commandId;
        this.commandArgs = builder.commandArgs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static APEXLangCompletionItem of(String choice, int type, APEXLangRange range) {
        return APEXLangCompletionItem.builder().choice(choice).type(type).range(range).build();
    }

    private static String sortTextFromIndex(int index) {
        return String.format("%03d", index);
    }

    public String choice() {
        return this.choice;
    }

    public int type() {
        return this.type;
    }

    public APEXLangRange range() {
        return this.range;
    }

    public String detail() {
        return this.detail;
    }

    public String insertText() {
        return this.insertText;
    }

    public int insertTextFormat() {
        return this.insertTextFormat;
    }

    public String sortText() {
        return this.sortText;
    }

    public String commandTitle() {
        return this.commandTitle;
    }

    public String commandId() {
        return this.commandId;
    }

    public List<Object> commandArgs() {
        return this.commandArgs;
    }

    public static final class Builder {
        private String choice;
        private int type;
        private APEXLangRange range;
        private String detail;
        private String insertText;
        private Integer insertTextFormat;
        private String sortText;
        private String commandTitle;
        private String commandId;
        private final List<Object> commandArgs = new ArrayList<Object>();

        private Builder() {
        }

        public Builder choice(String choice) {
            this.choice = choice;
            return this;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder range(APEXLangRange range) {
            this.range = range;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder insertText(String insertText) {
            this.insertText = insertText;
            return this;
        }

        public Builder insertTextFormat(Integer insertTextFormat) {
            this.insertTextFormat = insertTextFormat;
            return this;
        }

        public Builder index(int index) {
            return this.sortText(APEXLangCompletionItem.sortTextFromIndex(index));
        }

        public Builder sortText(String sortText) {
            this.sortText = sortText;
            return this;
        }

        public Builder commandTitle(String commandTitle) {
            this.commandTitle = commandTitle;
            return this;
        }

        public Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public Builder addCommandArgs(Object commandArg) {
            this.commandArgs.add(commandArg);
            return this;
        }

        public APEXLangCompletionItem build() {
            return new APEXLangCompletionItem(this);
        }
    }
}

