/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.net.URI;
import java.nio.file.Path;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Metametadata;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangApplicationState;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangTranspiler;

public class APEXLangApplicationStateContext {
    private final Map<URI, APEXLangApplicationState> cache;
    private final AtomicReference<State> state;
    private final Set<Pattern> knownPathRegexes;

    private APEXLangApplicationStateContext(Builder builder) {
        this.state = new AtomicReference<State>(State.SHUTDOWN);
        this.cache = new ConcurrentHashMap<URI, APEXLangApplicationState>();
        Metametadata metametadata = new APEXLangTranspiler().getMetaMetaData();
        HashSet<String> knownDirs = new HashSet<String>();
        for (ComponentType componentType : metametadata.getComponentTypes().values()) {
            int pos;
            String filePath = componentType.getFilePath();
            if (filePath == null || (pos = filePath.indexOf("/")) <= 0) continue;
            knownDirs.add(filePath.substring(0, pos));
        }
        this.knownPathRegexes = new HashSet<Pattern>();
        for (String path : knownDirs) {
            this.knownPathRegexes.add(Pattern.compile("^(.*/)" + path + "/.*"));
        }
    }

    protected APEXLangApplicationStateContext() {
        this.state = null;
        this.cache = null;
        this.knownPathRegexes = null;
    }

    public void activate() {
        this.state.compareAndSet(State.SHUTDOWN, State.ACTIVE);
    }

    public void shutdown() {
        this.state.getAndUpdate(state1 -> {
            if (state1 == State.ACTIVE) {
                this.cache.clear();
                return State.SHUTDOWN;
            }
            throw new ConcurrentModificationException();
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public APEXLangApplicationState getApplicationState(URI uri) {
        if (uri != null) {
            Path applicationRoot = this.getApplicationRoot(uri);
            return this.cache.computeIfAbsent(applicationRoot.toUri(), rp -> new APEXLangApplicationState(applicationRoot));
        }
        return null;
    }

    Path getApplicationRoot(URI uri) {
        String osIndepRet;
        Path ret;
        Path path = Path.of(uri);
        String osIndepPath = path.toUri().getPath();
        String root = this.knownPathRegexes.stream().map(re -> {
            Matcher m = re.matcher(osIndepPath);
            if (m.matches()) {
                return m.group(1);
            }
            return null;
        }).filter(p -> p != null).findFirst().orElse(Path.of(uri).getParent().toUri().getPath());
        if (path.toString().startsWith(root)) {
            return Path.of(root, new String[0]);
        }
        for (ret = path; ret != null && !root.equals(osIndepRet = ret.toUri().getPath()); ret = ret.getParent()) {
        }
        return ret;
    }

    private static enum State {
        ACTIVE,
        SHUTDOWN;

    }

    public static class Builder {
        public APEXLangApplicationStateContext build() {
            return new APEXLangApplicationStateContext(this);
        }
    }
}

