/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.request.processor;

import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.IResponseAdapter;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.RequestProcessor;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScopedRequestProcessor<Q extends IRequestBuilder, P extends IReply>
extends RequestProcessor<Q, P, ResponseAdapter> {
    private static final Logger logger = LoggerFactory.getLogger(ScopedRequestProcessor.class);
    private final ISendable sendable;

    protected abstract IResponse executeRequest(Q var1);

    protected abstract P buildReply(IResponse var1, IReply.Context var2);

    protected ScopedRequestProcessor(IRequestProcessor<?, ?> processor) {
        this.sendable = processor.getBuilder().getSendable();
    }

    @Override
    protected final ISendable getSendable() {
        return this.sendable;
    }

    @Override
    protected final Method getMethod() {
        return this.getSendable().getMethod();
    }

    @Override
    protected final Map getHeaders() {
        return this.getSendable().getHeaders();
    }

    @Override
    protected final Scope getScope() {
        return this.getSendable().getScope();
    }

    @Override
    public final String getUrl() {
        return this.getSendable().getUrl();
    }

    @Override
    protected ResponseAdapter doExecute(Q request) {
        IResponse response = this.executeRequest(request);
        ResponseAdapter responseAdapter = new ResponseAdapter(response);
        return responseAdapter;
    }

    protected boolean closeResponseUsedByReply(IResponse response) {
        if (response == null) {
            return false;
        }
        response.close();
        logger.debug(Marker.jaxrs.marker, "Closed response {} use by reply.", (Object)response);
        return true;
    }

    protected void onResponseClosed(IResponse response) {
    }

    class ResponseAdapter
    implements IResponseAdapter<P> {
        private final IResponse response;
        private boolean closed = false;

        public ResponseAdapter(IResponse response) {
            this.response = response;
        }

        @Override
        public P getReply(IReply.Context context) {
            Object reply = ScopedRequestProcessor.this.buildReply(this.response, context);
            return reply;
        }

        @Override
        public int getStatusCode() {
            int statusCode = this.response.getStatus();
            return statusCode;
        }

        @Override
        public void close(boolean usedByReply) {
            if (this.response == null || this.closed) {
                return;
            }
            if (usedByReply) {
                this.closed = ScopedRequestProcessor.this.closeResponseUsedByReply(this.response);
            } else {
                this.response.close();
                logger.debug(Marker.jaxrs.marker, "Closed {} which was not used by a reply.", (Object)this.response);
                this.closed = true;
            }
            if (this.closed) {
                ScopedRequestProcessor.this.onResponseClosed(this.response);
            }
        }
    }
}

