/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.extension.project.diff.ObjectDiff;
import oracle.dbtools.extension.project.diff.ParseDiff;
import oracle.dbtools.extension.project.diff.Row;
import oracle.dbtools.extension.project.diff.Table;
import oracle.dbtools.extension.project.diff.TableInfo;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.ParsedSql;

public class TableDiff
extends ObjectDiff {
    TableInfo ta1 = null;
    TableInfo ta2 = null;
    static final String separator = ",\n";

    public TableDiff(ParsedSql parsed1, ParsedSql parsed2) throws Exception {
        super(parsed1, parsed2);
        this.ta1 = new TableInfo((Parsed)parsed1);
        this.ta2 = new TableInfo((Parsed)parsed2);
    }

    @Override
    public String alters() {
        Object ret = "";
        String alter = "alter table " + this.ta1.tableName + "\n";
        ParseDiff inlineConstraintDiffs = new ParseDiff(this.ta1.inlineNamedConstraints, (Parsed)this.parsed1, this.ta2.inlineNamedConstraints, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 1;
            }
        };
        ParseDiff colDiffs = new ParseDiff(this.ta1.columnDefinitions, (Parsed)this.parsed1, this.ta2.columnDefinitions, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 0;
            }
        };
        LinkedList<String> included = new LinkedList<String>();
        for (String string : inlineConstraintDiffs.rename.keySet()) {
            String string2 = inlineConstraintDiffs.rename.get(string);
            for (String col : colDiffs.modify.keySet()) {
                String colDef = colDiffs.modify.get(col);
                if (!colDef.contains(string2)) continue;
                included.add(col);
            }
        }
        for (String string : included) {
            colDiffs.modify.remove(string);
        }
        for (String string : colDiffs.modify.keySet()) {
            String string3 = colDiffs.modify.get(string);
            if (!string3.contains("annotations")) continue;
            colDiffs.modify.remove(string);
        }
        if (colDiffs.modify.size() > 0) {
            LinkedList<String> notModifiable = new LinkedList<String>();
            for (String string : colDiffs.modify.keySet()) {
                int lenAfter;
                List tokensBefore = Lexer.parse((String)string);
                if ("long".equalsIgnoreCase(((LexerToken)tokensBefore.get((int)1)).content)) {
                    notModifiable.add(string);
                    colDiffs.delete.add(((LexerToken)tokensBefore.get((int)0)).content);
                    colDiffs.add.put(string, colDiffs.modify.get(string));
                    continue;
                }
                if (tokensBefore.size() < 5 || !"varchar2".equalsIgnoreCase(((LexerToken)tokensBefore.get((int)1)).content) || !"(".equals(((LexerToken)tokensBefore.get((int)2)).content) || ((LexerToken)tokensBefore.get((int)3)).type != Token.DIGITS) continue;
                String after = colDiffs.modify.get(string);
                List tokensAfter = Lexer.parse((String)after);
                int lenBefore = Integer.parseInt(((LexerToken)tokensBefore.get((int)3)).content);
                if (lenBefore <= (lenAfter = Integer.parseInt(((LexerToken)tokensAfter.get((int)3)).content))) continue;
                ret = (String)ret + "update " + this.ta1.tableName + " set " + ((LexerToken)tokensBefore.get((int)0)).content + "=substr(" + ((LexerToken)tokensBefore.get((int)0)).content + ",0," + lenAfter + ");\n";
            }
            colDiffs.modify.keySet().removeAll(notModifiable);
        }
        if (colDiffs.delete.size() > 0) {
            String[] split = this.ta1.tableName.split("\\.");
            if (split.length > 1 && split[0].equalsIgnoreCase("SYS")) {
                ret = (String)ret + "update " + this.ta1.tableName + "\nset ";
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                for (String col : colDiffs.delete) {
                    arrayList.add((CallSite)((Object)(col + " = null")));
                }
                ret = (String)ret + String.join((CharSequence)",\n    ", arrayList);
                ret = (String)ret + ";\n/\n";
            } else {
                ret = (String)ret + alter + " drop " + TableDiff.parenList(colDiffs.delete) + ";\n";
            }
        }
        for (String string : colDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename column " + string + " to " + colDiffs.rename.get(string) + ";\n";
        }
        if (colDiffs.add.size() > 0) {
            ret = (String)ret + alter + " add " + TableDiff.parenList(colDiffs.add) + ";\n";
        }
        if (colDiffs.modify.size() > 0) {
            ret = (String)ret + alter + " modify " + TableDiff.parenList(colDiffs.modify) + ";\n";
        }
        if (!this.ta2.pkColumns.equals(this.ta1.pkColumns) || !this.ta2.pkState.equals(this.ta1.pkState)) {
            if (this.ta1.pkColumns.size() > 0) {
                boolean hasOutOfLinePk = false;
                for (ParseNode parseNode : this.ta1.outOfLineNamedConstraints) {
                    for (ParseNode d : parseNode.descendants()) {
                        if (!d.contains("'PRIMARY'")) continue;
                        hasOutOfLinePk = true;
                    }
                }
                if (!hasOutOfLinePk) {
                    ret = (String)ret + alter + " drop primary key cascade;\n";
                }
            }
            if (this.ta2.pkColumns.size() > 0) {
                boolean hasOutOfLinePk = false;
                for (ParseNode parseNode : this.ta2.outOfLineNamedConstraints) {
                    for (ParseNode d : parseNode.descendants()) {
                        if (!d.contains("'PRIMARY'")) continue;
                        hasOutOfLinePk = true;
                    }
                }
                if (!hasOutOfLinePk) {
                    ret = (String)ret + alter + " add primary key " + TableDiff.parenList(this.ta2.pkColumns) + this.ta2.pkState + ";\n";
                }
            }
        }
        ParseDiff outOfLineConstraintDiffs = new ParseDiff(this.ta1.outOfLineNamedConstraints, (Parsed)this.parsed1, this.ta2.outOfLineNamedConstraints, (Parsed)this.parsed2){

            @Override
            public int nameIndex() {
                return 1;
            }
        };
        for (String string : outOfLineConstraintDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename constraint " + string + " to " + outOfLineConstraintDiffs.rename.get(string) + ";\n";
        }
        for (String string : outOfLineConstraintDiffs.delete) {
            ret = (String)ret + alter + " drop constraint " + string + ";\n";
        }
        for (String string : outOfLineConstraintDiffs.modify.keySet()) {
            ret = (String)ret + alter + " drop constraint " + string + ";\n";
        }
        for (String string : outOfLineConstraintDiffs.add.keySet()) {
            ret = (String)ret + alter + " add " + outOfLineConstraintDiffs.add.get(string) + ";\n";
        }
        for (String string : outOfLineConstraintDiffs.modify.keySet()) {
            ret = (String)ret + alter + " add " + outOfLineConstraintDiffs.modify.get(string) + ";\n";
        }
        for (String string : inlineConstraintDiffs.rename.keySet()) {
            ret = (String)ret + alter + " rename constraint " + string + " to " + inlineConstraintDiffs.rename.get(string) + ";\n";
        }
        ret = (String)ret + this.newAlters();
        return ret;
    }

    String newAlters() {
        Object ret = "\n";
        List<ParseNode> tmp = this.newClauses(this.ta1.extraAlters, this.ta2.extraAlters);
        for (ParseNode n : tmp) {
            String c = this.ta2.target.content(n);
            ret = (String)ret + c + ";\n";
        }
        return (String)ret + "\n";
    }

    private static String parenList(Collection<String> list) {
        Object ret = "(";
        for (String col : list) {
            ret = (String)ret + col + separator;
        }
        return ((String)ret).substring(0, ((String)ret).length() - separator.length()) + ")";
    }

    private static String parenList(Map<String, String> definitions) {
        Object ret = "(";
        for (String col : definitions.keySet()) {
            ret = (String)ret + definitions.get(col) + separator;
        }
        return ((String)ret).substring(0, ((String)ret).length() - separator.length()) + ")";
    }

    public static String deletions(Table table1, Table table2) {
        StringBuilder ret = new StringBuilder();
        List<Row> deletes = TableDiff.firstMinusSecond(table1, table2);
        int i = -1;
        for (Row row : deletes) {
            ++i;
            ret.append("delete from " + table1.tableName + " where ");
            for (int pos : table1.header.keySet()) {
                if (0 < pos) {
                    ret.append(" and ");
                }
                if (i % 5 == 0) {
                    ret.append("\n");
                }
                ret.append(table1.header.get(pos));
                String value = row.value(pos);
                if ("null".equals(value)) {
                    ret.append(" is ");
                } else {
                    ret.append(" = ");
                }
                ret.append(value);
            }
            ret.append(';');
        }
        return ret.toString();
    }

    static Table table(String tableName, Connection db) throws SQLException {
        return new Table(tableName, db);
    }

    public static String insertions(Table table1, Table table2) throws SQLException {
        StringBuilder ret = new StringBuilder();
        List<Row> inserts = TableDiff.firstMinusSecond(table2, table1);
        int i = -1;
        for (Row row : inserts) {
            ret.append("insert into " + table1.tableName + "(" + table2.columnList() + ") values (");
            ret.append(row.values());
            ret.append(");\n");
        }
        return ret.toString();
    }

    private static List<Row> firstMinusSecond(Table table1, Table table2) {
        LinkedList<Row> ret = new LinkedList<Row>();
        TreeMap<Row, Integer> cmp = new TreeMap<Row, Integer>();
        for (int i = 0; i < table2.cardinality(); ++i) {
            cmp.put(table2.grid.get(i), 1);
        }
        for (Row row1 : table1.grid) {
            Integer match = (Integer)cmp.get(row1);
            if (match != null) continue;
            ret.add(row1);
        }
        return ret;
    }

    public static String dml(String tableName, Connection db1, Connection db2) throws SQLException {
        Table table1 = TableDiff.table(tableName, db1);
        Table table2 = TableDiff.table(tableName, db2);
        Object ret = TableDiff.deletions(table1, table2);
        ret = (String)ret + TableDiff.insertions(table1, table2);
        return ret;
    }
}

