/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

public class Row
implements Comparable {
    Object[] cells;
    TreeMap<Integer, String> header;

    Row(TreeMap<Integer, String> header, ResultSet rs) throws SQLException {
        this.header = header;
        this.cells = new Object[header.size()];
        for (int i = 0; i < header.size(); ++i) {
            this.cells[i] = rs.getObject(i + 1);
        }
    }

    public int compareTo(Object o) {
        Row cmp = (Row)o;
        if (cmp.cells.length != this.cells.length) {
            return cmp.cells.length - this.cells.length;
        }
        for (int i = 0; i < this.cells.length; ++i) {
            int ret;
            if (this.cells[i] == null && cmp.cells[i] == null) continue;
            if (this.cells[i] == null && cmp.cells[i] != null) {
                return 1;
            }
            if (cmp.cells[i] == null && this.cells[i] != null) {
                return -1;
            }
            if (this.cells[i] instanceof Date || (ret = this.cells[i].toString().compareTo(cmp.cells[i].toString())) == 0) continue;
            return ret;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public String values() {
        StringBuilder ret = new StringBuilder();
        int cnt = -1;
        for (Object value : this.cells) {
            if (++cnt != 0) {
                ret.append(",");
            }
            if (cnt % 5 == 0) {
                ret.append("\n");
            }
            ret.append(this.value(cnt));
        }
        return ret.toString();
    }

    public String value(int col) {
        Object cell = this.cells[col];
        if (cell == null) {
            return null;
        }
        if (cell instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yy");
            return "'" + sdf.format(cell).toUpperCase() + "'";
        }
        return "'" + cell.toString() + "'";
    }
}

