/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.extension.project.diff.IndexDiff;
import oracle.dbtools.extension.project.diff.SchedulerDiff;
import oracle.dbtools.extension.project.diff.TableDiff;
import oracle.dbtools.extension.project.diff.TypeDiff;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.ParsedSql;

public abstract class ObjectDiff {
    ParsedSql parsed1 = null;
    ParsedSql parsed2 = null;

    public ObjectDiff(ParsedSql parsed1, ParsedSql parsed2) {
        this.parsed1 = parsed1;
        this.parsed2 = parsed2;
    }

    public abstract String alters();

    public static ObjectDiff instantiate(String input1, String input2) throws Exception {
        ParsedSql parsed1 = new ParsedSql(input1);
        ParsedSql parsed2 = new ParsedSql(input2);
        boolean isTable = false;
        for (ParseNode node : parsed1.getRoot().descendants()) {
            if (node.contains("create_table")) {
                return new TableDiff(parsed1, parsed2);
            }
            if (node.contains("adt_definition") || node.contains("table_type_definition")) {
                return new TypeDiff(parsed1, parsed2);
            }
            if (node.contains("create_index")) {
                return new IndexDiff(parsed1, parsed2);
            }
            if (!node.contains("dotted_expr") || !node.parent().parent().contains("unlabeled_nonblock_stmt") || !((LexerToken)parsed1.getSrc().get((int)node.from)).content.equalsIgnoreCase("DBMS_SCHEDULER")) continue;
            return new SchedulerDiff(parsed1, parsed2);
        }
        return null;
    }

    List<ParseNode> newClauses(Collection<ParseNode> p1, Collection<ParseNode> p2) {
        LinkedList<ParseNode> ret = new LinkedList<ParseNode>();
        block0: for (ParseNode node2 : p2) {
            for (ParseNode node1 : p1) {
                if (!ObjectDiff.lexMatches(node1, this.parsed1, node2, this.parsed2)) continue;
                continue block0;
            }
            ret.add(node2);
        }
        return ret;
    }

    static boolean lexMatches(ParseNode node1, ParsedSql parsed1, ParseNode node2, ParsedSql parsed2) {
        List src1 = parsed1.getSrc().subList(node1.from, node1.to);
        List src2 = parsed2.getSrc().subList(node2.from, node2.to);
        if (src1.size() != src2.size()) {
            return false;
        }
        for (int i = 0; i < src1.size(); ++i) {
            if (((LexerToken)src1.get((int)i)).content.equalsIgnoreCase(((LexerToken)src2.get((int)i)).content)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        String before = "BEGIN\n       DBMS_SCHEDULER.create_schedule (\n          schedule_name => 'BSLN_MAINTAIN_STATS_SCHED'\n  ,start_date=>timestamp '2024-10-13 00:00:00.0'\n ,end_date=>timestamp '2024-10-13 00:00:00.0'\n ,repeat_interval=>'FREQ=WEEKLY'\n ,comments=>'Pre-defined schedule for computing moving window baseline statistics'\n );\n     END;\n /";
        String after = "BEGIN\n       DBMS_SCHEDULER.create_schedule (\n          schedule_name => 'BSLN_MAINTAIN_STATS_SCHED'\n  ,start_date=>timestamp '2025-01-19 00:00:00.0'\n ,end_date=>timestamp '2025-01-19 00:00:00.0'\n ,repeat_interval=>'FREQ=WEEKLY'\n ,comments=>'Pre-defined schedule for computing moving window baseline statistics'\n );\n     END;\n/";
        String alter = ObjectDiff.instantiate(before, after).alters();
        System.out.println(alter);
    }
}

