/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage.apex;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;

public abstract class CommonApexProcessing
implements VerifyServiceInterface {
    List<String> parseApexChangelog(Path apexChangelog) {
        try {
            String apexChangeLogContent = new String(Files.readAllBytes(Paths.get(apexChangelog.toUri())));
            Pattern pattern = Pattern.compile("file\\s*=\\s*\"([^/\"]+)/[^\"]*\"");
            Matcher match = pattern.matcher(apexChangeLogContent);
            ArrayList<String> apexAppsNames = new ArrayList<String>();
            while (match.find()) {
                apexAppsNames.add(match.group(1));
            }
            return apexAppsNames;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
            return List.of();
        }
    }

    boolean noApexAppStaged(Path file) {
        Pattern pattern = Pattern.compile("file\\s*=\\s*\"[^\"]*apex/apex.changelog[.xml^\"]*\"");
        try {
            String mainChangelog = new String(Files.readAllBytes(Paths.get(file.toUri())));
            Matcher matcher = pattern.matcher(mainChangelog);
            return !matcher.find();
        }
        catch (Exception exception) {
            return true;
        }
    }
}

