/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage.apex;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.extension.project.core.verify.services.stage.apex.CommonApexProcessing;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;

public class ApexInSrcMatchesDist
extends CommonApexProcessing {
    @Override
    public String getName() {
        return "apexinsrcmatchesdist";
    }

    @Override
    public String getGroup() {
        return "stageApex";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        ArrayList<String> appsWithDifferentContents = new ArrayList<String>();
        ArrayList<String> appsExistInDistNotSrc = new ArrayList<String>();
        HashMap<String, String> apexAppOwnerMap = new HashMap<String, String>();
        Path initialApexPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/apex/");
        Path srcPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "src/database/");
        Pattern pattern = Pattern.compile(",p_default_owner=>'(.*)'");
        try (DirectoryStream<Path> apexApps = Files.newDirectoryStream(initialApexPath);){
            for (Path apexApp : apexApps) {
                String content;
                Matcher matcher;
                String apexAppName;
                Path sqlFilePath;
                if (!Files.isDirectory(apexApp, new LinkOption[0]) || !Files.exists(sqlFilePath = apexApp.resolve((apexAppName = apexApp.getFileName().toString()) + ".sql"), new LinkOption[0]) || !(matcher = pattern.matcher(content = Files.readString(sqlFilePath))).find()) continue;
                String appOwner = matcher.group(1);
                apexAppOwnerMap.put(apexAppName, appOwner);
            }
        }
        catch (IOException e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
            return false;
        }
        for (String apexAppName : apexAppOwnerMap.keySet()) {
            Path apexSrcApp = srcPath.resolve(Paths.get(((String)apexAppOwnerMap.get(apexAppName)).toLowerCase(), "apex_apps", apexAppName.toLowerCase(), apexAppName.toLowerCase() + ".sql"));
            Path apexDirApp = initialApexPath.resolve(apexAppName).resolve(apexAppName + ".sql");
            if (Files.exists(apexSrcApp, new LinkOption[0])) {
                try {
                    String sourceContent = Files.readString(apexSrcApp);
                    String distContent = Files.readString(apexDirApp);
                    RawText src = new RawText(sourceContent.getBytes());
                    RawText dist = new RawText(distContent.getBytes());
                    EditList differ = new EditList();
                    differ.addAll((Collection)new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)src, (Sequence)dist));
                    if (differ.isEmpty()) continue;
                    appsWithDifferentContents.add(apexAppName);
                    continue;
                }
                catch (IOException e) {
                    this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
                    return false;
                }
            }
            appsExistInDistNotSrc.add(apexAppName);
        }
        if (appsExistInDistNotSrc.isEmpty() && appsWithDifferentContents.isEmpty()) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("APEXDISTSRCMATCH", new Object[0]));
            return true;
        }
        if (!appsExistInDistNotSrc.isEmpty()) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("APEXDISTSRCMISSING", ((Object)appsExistInDistNotSrc).toString()));
        }
        if (!appsWithDifferentContents.isEmpty()) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("APEXDISTSRCMISMATCH", ((Object)appsWithDifferentContents).toString()));
        }
        return false;
    }
}

