/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage.apex;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.extension.project.core.verify.services.stage.apex.CommonApexProcessing;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ApexChangelogComplete
extends CommonApexProcessing {
    @Override
    public String getName() {
        return "apexchangelogcomplete";
    }

    @Override
    public String getGroup() {
        return "stageApex";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        ArrayList<String> unexpectedDirs = new ArrayList<String>();
        Path initialApexPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/apex/");
        Path apexChangelogPath = Paths.get(initialApexPath.toString(), "apex.changelog.xml");
        Path mainChangelog = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/main.changelog.xml");
        if (this.noApexAppStaged(mainChangelog)) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("NOAPEXAPPLICATIONSTAGE", new Object[0]));
            return true;
        }
        if (!Files.exists(initialApexPath, new LinkOption[0])) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("APEXINMAINNOTINAPEXDIR", new Object[0]));
            return false;
        }
        List<String> apexAppsChangelog = this.parseApexChangelog(apexChangelogPath);
        ArrayList<String> actualApexApps = new ArrayList<String>();
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(initialApexPath);){
            for (Path dir : dirs) {
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                actualApexApps.add(dir.getFileName().toString());
            }
        }
        catch (IOException e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
        }
        for (String dir : actualApexApps) {
            if (apexAppsChangelog.contains(dir)) continue;
            unexpectedDirs.add(dir);
        }
        if (unexpectedDirs.isEmpty()) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("APEXAPPLICATIONSCLOGOK", new Object[0]));
            return true;
        }
        if (unexpectedDirs.size() == 1) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("UNEXPECTEDAPEXAPPSTAGED", unexpectedDirs.get(0)));
            return false;
        }
        this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("UNEXPECTEDAPEXAPPSSTAGED", ((Object)unexpectedDirs).toString()));
        return false;
    }
}

