/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage.apex;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.extension.project.core.verify.services.stage.apex.CommonApexProcessing;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ApexChangeLogFilesValid
extends CommonApexProcessing {
    List<String> missingApexFiles;

    @Override
    public String getName() {
        return "apexchangelogfilesvalid";
    }

    @Override
    public String getGroup() {
        return "stageApex";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        this.missingApexFiles = new ArrayList<String>();
        Path initialApexPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/apex/");
        Path mainChangelog = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/main.changelog.xml");
        if (this.noApexAppStaged(mainChangelog)) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("NOAPEXAPPLICATIONSTAGE", new Object[0]));
            return true;
        }
        if (!Files.exists(initialApexPath, new LinkOption[0])) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("APEXINMAINNOTINAPEXDIR", new Object[0]));
            return false;
        }
        try {
            Path apexChangelogPath = Paths.get(initialApexPath.toString(), "apex.changelog.xml");
            List<String> fileList = this.parseApexChangelog(apexChangelogPath);
            for (String fileName : fileList) {
                Path xmlFilePath = Paths.get(initialApexPath.toString(), fileName + "/" + fileName + ".xml");
                Path sqlFilePath = Paths.get(initialApexPath.toString(), fileName + "/" + fileName + ".sql");
                if (!Files.exists(xmlFilePath, new LinkOption[0])) {
                    this.missingApexFiles.add(fileName + ".xml");
                }
                if (Files.exists(sqlFilePath, new LinkOption[0])) continue;
                this.missingApexFiles.add(fileName + ".sql");
            }
            if (this.missingApexFiles.isEmpty()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("APEXAPPLICATIONSOK", new Object[0]));
                return true;
            }
            if (this.missingApexFiles.size() == 1) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("MISSINGAPEXFILE", this.missingApexFiles.get(0)));
                return false;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("MISSINGAPEXFILES", this.missingApexFiles.toString()));
            return false;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
            return false;
        }
    }
}

