/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class StageDuplicateEntries
implements VerifyServiceInterface {
    private static final Pattern INCLUDE_PATTERN_SQL = Pattern.compile("^\\s*(?:(?:@@|@)|START\\s+)([^\"\\s]+)");
    private static final Pattern INCLUDE_PATTERN_XML = Pattern.compile(".*<include file=\"([^\"]*)\" relativeToChangelogFile=\"true\"/>.*");
    private static Pattern usedPattern = INCLUDE_PATTERN_SQL;
    private static Path initialFilePath;
    private static String issueReadingFileMessage;
    private static HashMap<Path, Integer> mainChangelogDuplicateEntries;
    private static HashMap<Path, HashMap<Path, Integer>> releaseChangelogsDuplicateEntries;
    private static HashMap<Path, HashMap<Path, Integer>> stageChangelogsDuplicateEntries;
    private static boolean changelogError;

    @Override
    public String getName() {
        return "stageduplicateentries";
    }

    @Override
    public String getGroup() {
        return "stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        HashMap<Path, Integer> duplicateEntries;
        initialFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/main.changelog.sql");
        issueReadingFileMessage = "";
        mainChangelogDuplicateEntries = new HashMap();
        ArrayList<Path> mainChangelogIncludedFilesPaths = new ArrayList<Path>();
        releaseChangelogsDuplicateEntries = new HashMap();
        ArrayList<Path> releaseChangelogsIncludedFilesPaths = new ArrayList<Path>();
        stageChangelogsDuplicateEntries = new HashMap();
        changelogError = false;
        StringBuilder message = new StringBuilder();
        String stageGeneratedFormat = (String)ProjectSettings.getConfigValue("stage.generatedFormat");
        if ("sql".equals(stageGeneratedFormat)) {
            initialFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/main.changelog.sql");
            usedPattern = INCLUDE_PATTERN_SQL;
        } else if ("liquibase".equals(stageGeneratedFormat)) {
            initialFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/main.changelog.xml");
            usedPattern = INCLUDE_PATTERN_XML;
        }
        message.append(VerifyMessages.format("DUPLICATEENTRIES_GENERATED_FORMAT", stageGeneratedFormat));
        mainChangelogDuplicateEntries = this.checkDuplicateEntries(initialFilePath, mainChangelogIncludedFilesPaths);
        message.append("\n");
        if (!issueReadingFileMessage.isEmpty()) {
            message.append(issueReadingFileMessage);
            issueReadingFileMessage = "";
        } else {
            message.append(StageDuplicateEntries.getMainChangelogMessage());
        }
        for (Path releasePath : mainChangelogIncludedFilesPaths) {
            ArrayList<Path> currentReleasePathIncludedFilesPaths;
            duplicateEntries = this.checkDuplicateEntries(releasePath, currentReleasePathIncludedFilesPaths = new ArrayList<Path>());
            if (!duplicateEntries.isEmpty()) {
                releaseChangelogsDuplicateEntries.put(Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(releasePath), duplicateEntries);
            }
            releaseChangelogsIncludedFilesPaths.addAll(currentReleasePathIncludedFilesPaths);
            if (issueReadingFileMessage.isEmpty()) continue;
            message.append("\n");
            message.append(issueReadingFileMessage);
            issueReadingFileMessage = "";
        }
        message.append("\n");
        message.append(StageDuplicateEntries.getReleaseOrStageChangelogMessage(ChangelogType.RELEASE));
        for (Path stagePath : releaseChangelogsIncludedFilesPaths) {
            ArrayList<Path> currentStagePathIncludedFilesPaths;
            duplicateEntries = this.checkDuplicateEntries(stagePath, currentStagePathIncludedFilesPaths = new ArrayList<Path>());
            if (!duplicateEntries.isEmpty()) {
                stageChangelogsDuplicateEntries.put(Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(stagePath), duplicateEntries);
            }
            if (issueReadingFileMessage.isEmpty()) continue;
            message.append("\n");
            message.append(issueReadingFileMessage);
            issueReadingFileMessage = "";
        }
        message.append("\n");
        message.append(StageDuplicateEntries.getReleaseOrStageChangelogMessage(ChangelogType.STAGE));
        if (changelogError) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, message.toString());
            return false;
        }
        this.addMessage(VerifyServiceInterface.MessageLevel.INFO, message.toString());
        return true;
    }

    private HashMap<Path, Integer> checkDuplicateEntries(Path includingFilePath, List<Path> changelogIncludedFilesPaths) {
        HashMap<Path, Integer> changelogDuplicateEntries = new HashMap<Path, Integer>();
        Path absoluteNormalizedPath = includingFilePath.toAbsolutePath().normalize();
        try (BufferedReader reader = Files.newBufferedReader(absoluteNormalizedPath);){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = usedPattern.matcher(line);
                if (!matcher.matches()) continue;
                String includedRelativePathStr = matcher.group(1);
                Path currentDir = absoluteNormalizedPath.getParent();
                Path includedAbsolutePath = currentDir.resolve(includedRelativePathStr).normalize();
                if (changelogIncludedFilesPaths.contains(includedAbsolutePath)) {
                    Path currentPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(includedAbsolutePath);
                    if (changelogDuplicateEntries.containsKey(currentPath)) {
                        changelogDuplicateEntries.put(currentPath, changelogDuplicateEntries.get(currentPath) + 1);
                        continue;
                    }
                    changelogDuplicateEntries.put(currentPath, 1);
                    continue;
                }
                changelogIncludedFilesPaths.add(includedAbsolutePath);
            }
        }
        catch (IOException e) {
            changelogError = true;
            issueReadingFileMessage = VerifyMessages.format("DUPLICATEENTRIES_ISSUE_READING_FILE", Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(absoluteNormalizedPath).toString());
        }
        return changelogDuplicateEntries;
    }

    private static String getMainChangelogMessage() {
        Path includingFilePathRelative = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(initialFilePath);
        if (mainChangelogDuplicateEntries.isEmpty()) {
            return VerifyMessages.format("DUPLICATEENTRIES_CHANGELOG_OK", includingFilePathRelative.toString());
        }
        changelogError = true;
        return StageDuplicateEntries.getDuplicatesMessage(includingFilePathRelative, mainChangelogDuplicateEntries);
    }

    private static String getReleaseOrStageChangelogMessage(ChangelogType changelogType) {
        switch (changelogType.ordinal()) {
            case 0: {
                if (releaseChangelogsDuplicateEntries.isEmpty()) {
                    return VerifyMessages.format("DUPLICATEENTRIES_CHANGELOG_OK", VerifyMessages.getString("DUPLICATEENTRIES_RELEASECHANGELOG"));
                }
                return StageDuplicateEntries.appendDuplicateMessage(releaseChangelogsDuplicateEntries);
            }
            case 1: {
                if (stageChangelogsDuplicateEntries.isEmpty()) {
                    return VerifyMessages.format("DUPLICATEENTRIES_CHANGELOG_OK", VerifyMessages.getString("DUPLICATEENTRIES_STAGECHANGELOG"));
                }
                return StageDuplicateEntries.appendDuplicateMessage(stageChangelogsDuplicateEntries);
            }
        }
        return "Code error: all ChangelogType cases should be covered.";
    }

    private static String appendDuplicateMessage(HashMap<Path, HashMap<Path, Integer>> changelogsDuplicateEntries) {
        changelogError = true;
        StringBuilder message = new StringBuilder();
        int counter = 0;
        for (Map.Entry<Path, HashMap<Path, Integer>> entry : changelogsDuplicateEntries.entrySet()) {
            Path includingPath = entry.getKey();
            HashMap<Path, Integer> includedScripts = entry.getValue();
            if (counter != 0) {
                message.append("\n");
            }
            message.append(StageDuplicateEntries.getDuplicatesMessage(includingPath, includedScripts));
            ++counter;
        }
        return message.toString();
    }

    private static String getDuplicatesMessage(Path includingFilePathRelative, HashMap<Path, Integer> duplicateEntries) {
        if (duplicateEntries.size() == 1) {
            Path path = duplicateEntries.keySet().iterator().next();
            Integer pathCount = duplicateEntries.values().iterator().next();
            if (pathCount == 1) {
                return VerifyMessages.format("DUPLICATEENTRIES_CHANGELOG_DUPLICATE", includingFilePathRelative.toString(), "\t" + path.toString());
            }
            String countMessage = VerifyMessages.format("DUPLICATEENTRIES_TIMES", pathCount);
            return VerifyMessages.format("DUPLICATEENTRIES_CHANGELOG_DUPLICATE", includingFilePathRelative.toString(), "\t" + path.toString() + " " + countMessage);
        }
        StringBuilder duplicateEntriesList = new StringBuilder();
        int counter = 0;
        for (Map.Entry<Path, Integer> entry : duplicateEntries.entrySet()) {
            if (counter != 0) {
                duplicateEntriesList.append("\n");
            }
            Path currentPath = entry.getKey();
            Integer currentCount = entry.getValue();
            if (currentCount == 1) {
                duplicateEntriesList.append("\t").append(currentPath.toString());
            } else {
                String countMessage = VerifyMessages.format("DUPLICATEENTRIES_TIMES", currentCount);
                duplicateEntriesList.append("\t").append(currentPath.toString()).append(" ").append(countMessage);
            }
            ++counter;
        }
        return VerifyMessages.format("DUPLICATEENTRIES_CHANGELOG_DUPLICATES", includingFilePathRelative.toString(), duplicateEntries.size(), duplicateEntriesList);
    }

    static {
        issueReadingFileMessage = "";
        changelogError = false;
    }

    private static enum ChangelogType {
        RELEASE,
        STAGE;

    }
}

