/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.settings;

import java.util.HashMap;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;

public class NonPublicSettings
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "verifyNonPublicSettings";
    }

    @Override
    public String getGroup() {
        return "settings";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        boolean status = true;
        for (String key : ProjectSettings.getUserConfigMap().keySet()) {
            if (!ProjectSettings.getSystemConfigMap().get(key).getPub().equals("N")) continue;
            String msg = VerifyMessages.format("NON_PUBLIC_SETTINGS", key);
            this.addMessage(VerifyServiceInterface.MessageLevel.WARN, msg);
            status = false;
        }
        if (status) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.getString("NON_PUBLIC_SETTINGS_INFO"));
        }
        return status;
    }
}

