/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.init;

import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.HashMap;
import java.util.LinkedList;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.init.InitMessages;
import oracle.dbtools.extension.project.commands.init.utils.InitUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.NamedConnections;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.verify.VerifyEngine;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class InitCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        try {
            ProjectConfig.setupDebugVerbose(parsedCommand);
            ProjectSettings.getSystemConfigMap().clear();
            ProjectSettings.getUserConfigMap().clear();
            ProjectSettings.loadSystemSettings();
            String projectName = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.NAME);
            LinkedList<String> schemas = (LinkedList<String>)parsedCommand.getOptionValue((Id)ProjectOptions.Options.SCHEMAS);
            String directory = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.DIRECTORY);
            String connectionName = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.CONNECTION_NAME);
            boolean makeRoot = parsedCommand.isFlagSet((Id)ProjectOptions.Options.MAKEROOT);
            boolean directorySpecified = directory != null && !directory.isEmpty();
            StringBuilder schemabld = new StringBuilder();
            if (connectionName == null || connectionName.isEmpty() || connectionName.isBlank()) {
                String connName = NamedConnections.getCurrentConnectionName();
                connectionName = connName == null ? "" : connName;
            }
            GeneralMessages.verboseMessage(InitMessages.get("PROJECT_VERIFY"));
            VerifyEngine engine = VerifyEngine.getInstance();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("projectName", projectName);
            params.put("singleSpaces", true);
            params.put("replaceWhitespace", true);
            boolean status = engine.runService("VerifyProjectName", params);
            String finalProjectNameMessage = engine.getGroupMessages("Init").get("verifyprojectname").get(0).getMessage();
            GeneralMessages.verboseMessage(finalProjectNameMessage);
            InitUtils utils = new InitUtils();
            Path root = utils.buildProjectRoot(projectName, directory, makeRoot);
            String existingProject = ProjectFileUtils.findProjectRoot(root.toString());
            if (Files.exists(this.getConfigPath(root.toString()), new LinkOption[0])) {
                GeneralMessages.errorMessage(ProjectMessages.format("PROJECT_ALREADY_EXIST_EXCEPTION", existingProject, root));
                return;
            }
            if (existingProject != null) {
                if (directorySpecified) {
                    this.deleteEmptyDirs(existingProject, root);
                }
                GeneralMessages.errorMessage(ProjectMessages.format("NESTED_PROJECT_EXCEPTION", projectName, existingProject));
                return;
            }
            if (schemas == null || schemas.isEmpty()) {
                schemas = new LinkedList<String>();
            }
            utils.checkDirectoriesAndFiles(root, schemas);
            ProjectSettings.updateValue("schemas", schemas.toString(), "ARRAY", root.toString());
            ProjectSettings.updateValue("project", projectName, "STRING", root.toString());
            ProjectSettings.updateValue("sqlcl.connectionName", connectionName, "STRING", root.toString());
            ProjectSettings.updateValue("sqlcl.version", ProjectConfig.getSqlclVersion(), "STRING", root.toString());
            if (conn != null) {
                LinkedList<String> exptype = new LinkedList<String>();
                try {
                    Version apexVersion = new Version(ApexUtil.getApexVersion((Connection)conn));
                    if (apexVersion.compareTo(new Version("25.1")) >= 0) {
                        exptype.add("APEXLANG");
                    } else {
                        exptype.add("READABLE_YAML");
                    }
                }
                catch (AppNotInstalledException e) {
                    exptype.add("READABLE_YAML");
                }
                exptype.add("APPLICATION_SOURCE");
                ProjectSettings.updateValue("export.apex.exptype", exptype.toString(), "ARRAY", root.toString());
            }
            ProjectSettings.writeUserSettings(root.toString());
            ctx.writeln(ProjectMessages.format("PROJECT_INIT", projectName, schemas.toString().replace("[", "").replace("]", ""), root, connectionName, root.getFileName()));
            GeneralMessages.successMessage(ProjectMessages.format("PROJECT_CREATED", new Object[0]));
        }
        catch (Exception e) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROJECT_INIT_FAILED", e.getLocalizedMessage()));
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void deleteEmptyDirs(String existingProjectPath, Path providedProjectPath) {
        while (!providedProjectPath.toString().equalsIgnoreCase(existingProjectPath)) {
            File f = new File(providedProjectPath.toString());
            String[] fileList = f.list();
            if (!f.isDirectory() || fileList == null || fileList.length != 0) break;
            boolean deleted = f.delete();
            if (!deleted) {
                GeneralMessages.debugMessage("Failed to delete directory: " + f.getAbsolutePath());
            }
            providedProjectPath = providedProjectPath.getParent();
        }
    }

    private Path getConfigPath(String root) {
        return Paths.get(root, ".dbtools", "project.config.json");
    }
}

