/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.deploy;

import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.deploy.DeployMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectConnectionException;
import oracle.dbtools.extension.project.core.exceptions.ProjectDBConnectionException;
import oracle.dbtools.extension.project.core.exceptions.ProjectDeployException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.utils.FileCompressionUtils;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.runner.SqlClCommandsRunner;
import org.apache.commons.io.FilenameUtils;

public class DeployCommand
implements CommandInterface {
    private static final boolean OS_IS_WINDOWS;
    ScriptRunnerContext originalCtx;
    private String originalCwd;
    private Object originalCdpath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        block22: {
            Path artifactPath = null;
            try {
                Path logPath;
                ProjectConfig.setupDebugVerbose(command);
                String fileOption = (String)command.getOptionValue((Id)ProjectOptions.Options.FILE);
                String logOption = (String)command.getOptionValue((Id)ProjectOptions.Options.LOG_PATH);
                Path path = logPath = logOption != null ? Path.of(logOption, new String[0]) : Path.of(ProjectConfig.getCWD(), new String[0]);
                if (!logPath.isAbsolute()) {
                    logPath = Path.of(ProjectConfig.getCWD(), new String[0]).resolve(logPath).normalize();
                }
                if (conn == null) {
                    throw new ProjectConnectionException(ProjectMessages.getString("NO_CONNECTION"));
                }
                this.originalCdpath = ctx.getProperty("script.runner.cd_command");
                this.originalCwd = (String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString());
                this.originalCtx = ProjectConfig.getCurrentContext();
                if (OS_IS_WINDOWS) {
                    if (!(fileOption = Paths.get(fileOption, new String[0]).normalize().toString()).startsWith("\\")) {
                        fileOption = Paths.get(ProjectConfig.getCWD(), fileOption).normalize().toString();
                    }
                } else {
                    fileOption = !fileOption.contains("~") && !fileOption.startsWith("/") ? Path.of(ProjectConfig.getCWD(), fileOption).toString() : ProjectFileUtils.expandTilde(fileOption);
                }
                GeneralMessages.verboseMessage(DeployMessages.getString("CHECK_DB_CONN"));
                if (ctx.getCurrentConnection() == null) {
                    GeneralMessages.errorMessage(DeployMessages.getString("DB_CONN_EXCEPTION"));
                    throw new ProjectDBConnectionException(DeployMessages.getString("DB_CONN_EXCEPTION"));
                }
                File file = new File(fileOption);
                if (!file.exists()) {
                    throw new ProjectDBConnectionException(DeployMessages.format("FILE_DOESNT_EXIST", file));
                }
                String baseName = FilenameUtils.getBaseName((String)file.toString());
                GeneralMessages.verboseMessage(DeployMessages.format("EXTRACT_FILE_NAME", baseName));
                if (file.exists() && file.isFile()) {
                    GeneralMessages.verboseMessage(DeployMessages.format("ARTIFACT_DECOMPRESSION", new Object[0]));
                    UUID uuid = UUID.randomUUID();
                    artifactPath = Files.createTempDirectory(uuid.toString(), new FileAttribute[0]);
                    FileCompressionUtils.decompressFile(Path.of(file.getPath(), new String[0]), artifactPath);
                    GeneralMessages.verboseMessage(DeployMessages.format("ARTIFACT_DECOMPRESSED", artifactPath));
                    Path installPath = Paths.get(artifactPath.toString(), "install.sql");
                    if (installPath.toFile().exists()) {
                        GeneralMessages.successMessage(DeployMessages.format("STARTING_MIGRATION", new Object[0]));
                        List<String> lines = Files.readAllLines(installPath);
                        ArrayList<String> updatedLines = new ArrayList<String>();
                        boolean logfilecreated = false;
                        Pattern logPattern = Pattern.compile("(?<![\\w-])-log(?![\\w-])");
                        Pattern logPathPattern = Pattern.compile("(?<![\\w-])-log-path(?![\\w-])");
                        for (String line : lines) {
                            if (logPattern.matcher(line).find() && !logPathPattern.matcher(line).find()) {
                                line = line.replaceFirst(logPattern.pattern(), "-log -log-path \"" + Matcher.quoteReplacement(logPath.toString()) + "\"");
                                logfilecreated = true;
                            }
                            updatedLines.add(line);
                        }
                        Files.write(installPath, updatedLines, new OpenOption[0]);
                        ctx.putProperty("script.runner.cd_command", (Object)artifactPath.toString());
                        ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), artifactPath.toString());
                        LbUtils.setPctx((ScriptRunnerContext)ctx);
                        LbUtils.getConfig().setContext(ctx);
                        SqlClCommandsRunner sqlClCommandsRunner = SqlClCommandsRunner.builder().context(ctx).connection(conn).build();
                        String out = sqlClCommandsRunner.run("cd " + String.valueOf(artifactPath) + "\n@install.sql\n");
                        ctx.writeln(out);
                        if (logfilecreated) {
                            GeneralMessages.verboseMessage(DeployMessages.format("LOG_FILES_LOCATION", logPath));
                        }
                    } else {
                        throw new ProjectDeployException(DeployMessages.format("INSTALL_DOESNT_EXIST", new Object[0]));
                    }
                    GeneralMessages.verboseMessage(DeployMessages.format("REMOVE_DECOMPRESSED_ARTIFACT", artifactPath));
                    break block22;
                }
                throw new ProjectDeployException(DeployMessages.format("NO_PROPER_ARTIFACT_PROVIDED", new Object[0]));
            }
            catch (ProjectConnectionException pe) {
                GeneralMessages.errorMessage(pe.getMessage());
            }
            catch (Exception e) {
                if (ctx.getCurrentConnection() != null) {
                    GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getLocalizedMessage()));
                }
                GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                LbUtils.getConfig().setContext(this.originalCtx);
                ctx.putProperty("script.runner.cd_command", this.originalCdpath);
                ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), this.originalCwd);
                if (artifactPath != null) {
                    ProjectFileUtils.recursiveDelete(artifactPath.toFile());
                }
            }
        }
    }

    static {
        String os = System.getProperty("os.name");
        OS_IS_WINDOWS = os.startsWith("Windows");
    }
}

