/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import oracle.dbtools.data.readservice.ReadParmsAPI;
import oracle.dbtools.data.readservice.ReadService;

public class ReadParmsXLSAPI
extends ReadParmsAPI {
    private ReadParmsAPI.SERVICE_TYPE serviceType;
    private int lineMax;
    private String lineEnd;

    public ReadParmsXLSAPI(Builder builder) {
        super(builder.header, builder.headerBeforeSkip, builder.skipRows, builder.limitRows, builder.readServiceBuilder);
        this.serviceType = builder.serviceType;
    }

    public ReadParmsAPI.SERVICE_TYPE getServiceType() {
        return this.serviceType;
    }

    public static boolean isDelimiterWhiteSpace(String delimiter) {
        return delimiter.length() > 1 && delimiter.equals("  ");
    }

    public static String getEnvTerminatorValue() {
        return System.getProperty("line.separator");
    }

    public String getTerminator() {
        return this.lineEnd;
    }

    public boolean getUseMaxLength() {
        return this.lineMax > 0;
    }

    public int getMaxLength() {
        return this.lineMax;
    }

    public static class Builder {
        private ReadParmsAPI.SERVICE_TYPE serviceType;
        private boolean header = true;
        private boolean headerBeforeSkip = true;
        private int skipRows = 0;
        private int limitRows = ReadParmsAPI.UNLIMITED;
        private ReadService.Builder readServiceBuilder;
        private String _lineEnd;
        private int _lineMax = ReadParmsAPI.UNLIMITED;

        public Builder() {
            this.serviceType = ReadParmsAPI.SERVICE_TYPE.XLS;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public Builder headerBeforeSkip(boolean headerBeforeSkip) {
            this.headerBeforeSkip = headerBeforeSkip;
            return this;
        }

        public Builder skipRows(int skipRows) {
            this.skipRows = skipRows;
            return this;
        }

        public Builder limitRows(int limitRows) {
            this.limitRows = limitRows;
            return this;
        }

        public Builder lineEnd(String lineEnd) {
            if (lineEnd != null) {
                if (lineEnd.equals("\\r")) {
                    this._lineEnd = "\r";
                } else if (lineEnd.equals("\\r\\n")) {
                    this._lineEnd = "\r\n";
                } else if (lineEnd.equals("\\n")) {
                    this._lineEnd = "\n";
                }
            }
            this._lineEnd = lineEnd;
            return this;
        }

        public Builder readServiceBuilder(ReadService.Builder readServiceBuilder) {
            this.readServiceBuilder = readServiceBuilder;
            return this;
        }

        public Builder serviceType(ReadParmsAPI.SERVICE_TYPE serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        public ReadParmsXLSAPI build() {
            return new ReadParmsXLSAPI(this);
        }
    }
}

