/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.core;

import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JLabel;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;

public class ImportSummaryWriter {
    public static void showConfig(PrintWriter writer, ImportProperties _iProps) {
        try {
            ImportSummaryWriter.writeConnection(writer, _iProps);
            ImportSummaryWriter.writeFile(writer, _iProps);
            ImportSummaryWriter.writeSelectedFields(writer, _iProps);
            ImportSummaryWriter.writeSelectableFields(writer, _iProps);
            ImportSummaryWriter.writeImportMethod(writer, _iProps);
        }
        catch (Exception exception) {
            // empty catch block
        }
        writer.flush();
    }

    public static void writeConnection(PrintWriter writer, ImportProperties _iProps) throws IOException {
        String destConn = (String)_iProps.get(ImportKeys.CONNECTION_NAME);
        ImportSummaryWriter.out(writer, ImportResources.getString("CONN"), 0);
        if (destConn != null) {
            String connDisplayName = ConnectionResolver.getDisplayName((String)destConn);
            ImportSummaryWriter.out(writer, ImportResources.getString("DEST_CONN") + ": " + connDisplayName, 1);
            BasicDBObject dbo = (BasicDBObject)_iProps.get(ImportKeys.DBOBJECT);
            ImportSummaryWriter.out(writer, ImportResources.getString("TABLE") + ": " + dbo.getSchemaName() + "." + dbo.getObjectName(), 1);
            GenericTable table = (GenericTable)_iProps.get(ImportKeys.TABLE);
            for (Column column : table.getColumns()) {
                JLabel col = new JLabel();
                ImportSummaryWriter.out(writer, ImportResources.getString("COLUMN") + ": " + column.getName(), 2);
            }
        }
    }

    public static void writeFile(PrintWriter writer, ImportProperties _iProps) throws IOException {
        LoadFile file = (LoadFile)_iProps.get(ImportKeys.LOAD_FILE);
        ImportSummaryWriter.out(writer, ImportResources.getString("FILE"), 0);
        if (file != null) {
            ImportSummaryWriter.out(writer, ImportResources.getString("SOURCE_FILE") + ": " + file.getName(), 1);
            ImportSummaryWriter.writeFileFormat(writer, _iProps);
            ImportSummaryWriter.out(writer, ImportResources.getString("FIELDS"), 1);
            for (LoadField loadField : file.getFields()) {
                ImportSummaryWriter.out(writer, ImportResources.getString("FIELD") + ": " + loadField.getName() + "  " + ImportResources.getString("SIZE") + ": " + loadField.getLength(), 2);
            }
        }
    }

    public static void writeSelectedFields(PrintWriter writer, ImportProperties _iProps) throws IOException {
        LoadFile file = (LoadFile)_iProps.get(ImportKeys.LOAD_FILE);
        ImportSummaryWriter.out(writer, ImportResources.getString("SEL_FIELDS"), 0);
        if (file != null) {
            Column[] cols;
            for (Column col : cols = (Column[])_iProps.get(ImportKeys.SELECTED_COLUMNS)) {
                ImportSummaryWriter.out(writer, ImportResources.getString("FIELD") + ": " + col.getSourceColumnName() + "  --> " + col.getName(), 1);
            }
        }
    }

    public static void writeSelectableFields(PrintWriter writer, ImportProperties _iProps) throws IOException {
        LoadFile file = (LoadFile)_iProps.get(ImportKeys.LOAD_FILE);
        ImportSummaryWriter.out(writer, ImportResources.getString("NOT_SEL_FIELDS"), 0);
        if (file != null) {
            Column[] cols;
            for (Column col : cols = (Column[])_iProps.get(ImportKeys.SELECTABLE_COLUMNS)) {
                ImportSummaryWriter.out(writer, ImportResources.getString("FIELD") + ": " + col.getSourceColumnName(), 1);
            }
        }
    }

    public static void writeFileFormat(PrintWriter writer, ImportProperties _iProps) throws IOException {
        ImportDataFormat dataFormat = (ImportDataFormat)_iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        ImportSummaryWriter.out(writer, ImportResources.getString("FILE_PROPERTIES") + ": " + dataFormat.getFormat() + " format", 1);
        if (dataFormat.isHeaderOptionSupported()) {
            ImportSummaryWriter.out(writer, ExtractResources.getString("HEADER") + (dataFormat.isHeader() ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
        }
        if (dataFormat.getSkipRows() > 0) {
            ImportSummaryWriter.out(writer, ImportResources.format("SKIP", new Integer(dataFormat.getSkipRows()).toString()), 2);
            if (dataFormat.isHeaderLocationSupported()) {
                if (dataFormat.isHeaderAfter()) {
                    ImportSummaryWriter.out(writer, ImportResources.getString("AFTER_SKIP"), 2);
                } else {
                    ImportSummaryWriter.out(writer, ImportResources.getString("BEFORE_SKIP"), 2);
                }
            }
        }
        if (dataFormat.getOptions().isDelimiterSupported()) {
            ImportSummaryWriter.out(writer, ExtractResources.getString("DELIMITER") + ": " + dataFormat.getDelimiter(), 2);
        }
        if (dataFormat.getOptions().isEnclosuresSupported()) {
            ImportSummaryWriter.out(writer, ExtractResources.getString("ENCLOSURE_LEFT") + ": " + dataFormat.getEnclosureLeft(), 2);
            ImportSummaryWriter.out(writer, ExtractResources.getString("ENCLOSURE_RIGHT") + ": " + dataFormat.getEnclosureRight(), 2);
        }
        if (dataFormat.getOptions().isLineTerminatorSupported()) {
            ImportSummaryWriter.out(writer, ExtractResources.getString("RECORD_TERMINATOR") + ": " + dataFormat.getRecordTerminator(), 2);
        }
        if (dataFormat.getWorksneet() != null && dataFormat.getWorksneet().length() > 0) {
            ImportSummaryWriter.out(writer, ExtractResources.getString("WORKSHEET_NAME") + ": " + dataFormat.getWorksneet(), 2);
        }
    }

    public static void writeImportMethod(PrintWriter writer, ImportProperties iProps) throws IOException {
        boolean use;
        ImportDataFormat dataFormat = (ImportDataFormat)iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        boolean isExistingTable = (Boolean)iProps.get(ImportKeys.IS_EXISTING_TABLE);
        int method = (Integer)iProps.get(ImportKeys.LOAD_METHOD);
        ImportSummaryWriter.out(writer, ImportResources.getString("SHOW_LOAD_METHOD") + ": " + ImportDataFormat.getLoadMethodName(method), 0);
        ImportSummaryWriter.out(writer, ImportResources.getString("METHOD_OPTIONS"), 1);
        boolean useLoadLimit = (Boolean)iProps.get(ImportKeys.USE_LOAD_LIMIT);
        ImportSummaryWriter.out(writer, ImportResources.getString("LIMIT_ROWS") + (useLoadLimit ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
        if (useLoadLimit) {
            ImportSummaryWriter.out(writer, ImportResources.getString("SHOW_LOAD_LIMIT") + " " + ((Integer)iProps.get(ImportKeys.LOAD_LIMIT)).toString(), 2);
        }
        if (!isExistingTable) {
            ImportSummaryWriter.out(writer, ImportResources.getString("METHOD_SEND_TO_WORKSHEET") + ((Boolean)iProps.get(ImportKeys.SEND_TO_WORKSHEET) != false ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
        }
        if (method == 3) {
            ImportSummaryWriter.out(writer, ImportResources.getString("STAGING_TABLE_NAME_LABEL") + " " + (String)iProps.get(ImportKeys.STAGING_TABLE_NAME), 2);
            ImportSummaryWriter.out(writer, ImportResources.getString(ImportResources.getString("METHOD_DROP_STAGING")) + ((Boolean)iProps.get(ImportKeys.DROP_STAGING_TABLE) != false ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
        }
        if (method == 3 || method == 2) {
            ImportSummaryWriter.out(writer, ImportResources.getString("EXTERNAL_TABLE_OPTIONS"), 1);
            ImportSummaryWriter.out(writer, ImportResources.getString("SERVER_SIDE_PATH") + " " + (String)iProps.get(ImportKeys.DIRPATH), 2);
            ImportSummaryWriter.out(writer, ImportResources.getString("ORACLE_DIRECTORY_NAME") + " " + (String)iProps.get(ImportKeys.ORADIRNAME), 2);
            use = (Boolean)iProps.get(ImportKeys.USELOGFILE);
            ImportSummaryWriter.out(writer, ImportResources.getString("USE_LOG") + (use ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
            if (use) {
                ImportSummaryWriter.out(writer, ImportResources.getString("ORACLE_DIRECTORY_NAME") + " " + (String)iProps.get(ImportKeys.ORALOGDIRNAME), 3);
            }
            use = (Boolean)iProps.get(ImportKeys.USEBADFILE);
            ImportSummaryWriter.out(writer, ImportResources.getString("USE_BAD") + (use ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
            if (use) {
                ImportSummaryWriter.out(writer, ImportResources.getString("ORACLE_DIRECTORY_NAME") + " " + (String)iProps.get(ImportKeys.ORABADDIRNAME), 3);
            }
            use = (Boolean)iProps.get(ImportKeys.USEDISCARDFILE);
            ImportSummaryWriter.out(writer, ImportResources.getString("USE_DISCARD") + (use ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
            if (use) {
                ImportSummaryWriter.out(writer, ImportResources.getString("ORACLE_DIRECTORY_NAME") + " " + (String)iProps.get(ImportKeys.ORADISCARDDIRNAME), 3);
            }
        } else if (method == 4) {
            ImportSummaryWriter.out(writer, ImportResources.getString("SQLLDR_OPTIONS"), 1);
            ImportSummaryWriter.out(writer, ImportResources.getString("LOG_FILE_DIR") + " " + (String)iProps.get(ImportKeys.LOGDIRNAME), 2);
            ImportSummaryWriter.out(writer, ImportResources.getString("BAD_FILE_DIR") + " " + (String)iProps.get(ImportKeys.BADDIRNAME), 2);
            use = (Boolean)iProps.get(ImportKeys.USEGENDIR) == false;
            ImportSummaryWriter.out(writer, ImportResources.getString("SAVE_IN_IMPORT") + (use ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
            ImportSummaryWriter.out(writer, ImportResources.getString("SAVE_IN_GEN_DIR") + " " + (String)iProps.get(ImportKeys.GENDIR), 3);
            ImportSummaryWriter.out(writer, ImportResources.getString("GENERATED_FILE_NEWLINE") + " " + (String)iProps.get(ImportKeys.FILEOUTNEWLINE), 2);
        }
        if (method == 3 || method == 2 || method == 4) {
            ImportSummaryWriter.out(writer, ImportResources.getString("GENERIC_OPTIONS"), 1);
            ImportSummaryWriter.out(writer, ImportResources.getString("NUMBER_OF_CHARACTERS") + " " + (String)iProps.get(ImportKeys.CHARNUMCHARACTERS), 2);
            String charSetVal = (String)iProps.get(ImportKeys.CHARSETVAL);
            boolean use2 = charSetVal != null && charSetVal.length() > 0;
            ImportSummaryWriter.out(writer, ImportResources.getString("GEN_FILE_CHARSET") + (use2 ? ImportDataFormat.TRUE : ImportDataFormat.FALSE), 2);
            if (use2) {
                ImportSummaryWriter.out(writer, ImportResources.getString("FILE_CHARSET") + ": " + charSetVal, 3);
            }
        }
    }

    public static void out(PrintWriter writer, String line, int indent) throws IOException {
        if (indent > 0) {
            writer.append(ImportSummaryWriter.getIndent(indent));
        }
        writer.append(line + "\n");
    }

    private static String getIndent(int idx) {
        Object indent = "";
        for (int i = 0; i < idx; ++i) {
            indent = (String)indent + "   ";
        }
        return indent;
    }
}

