/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.export.service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.dbtools.raptor.deployment.SDDeployAPI;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.util.Logger;

public class SDCloudDeployAPI
extends SDDeployAPI {
    private static final Class<?> clazz = SDCloudDeployAPI.class;

    public SDCloudDeployAPI(ToolLogger tLogger) {
        super(tLogger);
    }

    public void insertSdDeploy(String deployName, String fileLocation, String fileType, BigDecimal fileSize, String deploySchema, String cloudStorageLocation, String deployCredentialName) throws SQLException {
        SDDeployAPI.Deploy deploy = new SDDeployAPI.Deploy(deployName);
        deploy.status = "EXECUTING";
        deploy.startTime = new Timestamp(System.currentTimeMillis());
        deploy.fileLocation = fileLocation;
        deploy.type = fileType;
        deploy.deploySchema = deploySchema;
        deploy.cloudStorageLocation = cloudStorageLocation;
        deploy.cloudStorageCredential = deployCredentialName;
        deploy.requestedBy = this.getConnectionUser();
        super.insert((SDDeployAPI.Row)deploy);
    }

    public void updateSdDeploy(String deployName, String status) throws SQLException {
        SDDeployAPI.Deploy deploy = new SDDeployAPI.Deploy(deployName);
        deploy.status = status;
        deploy.stopTime = new Timestamp(System.currentTimeMillis());
        super.update((SDDeployAPI.Row)deploy);
    }

    public void insertSdDeployOperation(String deployName, int operationNumber, String operationFileName, String operationType) throws SQLException {
        SDDeployAPI.DeployOperation op = new SDDeployAPI.DeployOperation(deployName, Integer.valueOf(operationNumber));
        op.operationFileName = operationFileName;
        op.status = "EXECUTING";
        op.type = operationType;
        op.startTime = new Timestamp(System.currentTimeMillis());
        super.insert((SDDeployAPI.Row)op);
    }

    public void updateSdDeployOperation(String deployName, int operationNumber, String status, String logFileName, BigDecimal operationId, String displayFileFormat, String objectType, String objectName) throws SQLException {
        SDDeployAPI.DeployOperation op = new SDDeployAPI.DeployOperation(deployName, Integer.valueOf(operationNumber));
        op.status = status;
        op.operationId = operationId;
        op.fileFormat = displayFileFormat;
        op.objectType = objectType;
        op.objectName = objectName;
        op.stopTime = new Timestamp(System.currentTimeMillis());
        if (logFileName != null) {
            try {
                op.log = new BufferedReader(new FileReader(logFileName));
            }
            catch (Exception e) {
                Logger.warn(clazz, (Throwable)e);
            }
        }
        super.update((SDDeployAPI.Row)op);
    }

    public void updateSdDeployOperationBadFiles(String deployName, int operationNumber, String badFiles) throws SQLException {
        SDDeployAPI.DeployOperation op = new SDDeployAPI.DeployOperation(deployName, Integer.valueOf(operationNumber));
        op.badFileLocation = badFiles;
        op.stopTime = new Timestamp(System.currentTimeMillis());
        super.update((SDDeployAPI.Row)op);
    }

    public void updateSdDeployOperationPreview(String deployName, int operationNumber, String preview) throws SQLException {
        SDDeployAPI.DeployOperation op = new SDDeployAPI.DeployOperation(deployName, Integer.valueOf(operationNumber));
        op.badFilePreview = preview;
        op.stopTime = new Timestamp(System.currentTimeMillis());
        super.update((SDDeployAPI.Row)op);
    }

    public void updateSdDeployOperationLogFiles(String deployName, int operationNumber, String logFiles) throws SQLException {
        SDDeployAPI.DeployOperation op = new SDDeployAPI.DeployOperation(deployName, Integer.valueOf(operationNumber));
        op.logFileLocation = logFiles;
        op.stopTime = new Timestamp(System.currentTimeMillis());
        super.update((SDDeployAPI.Row)op);
    }
}

