/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ddl;

import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.common.ddl.DDLFormatConfig;

public class DDLFormat {
    public static final int UNDEFINED = 1;
    public static final int EXPORT = 1;
    public static final int DIFF = 2;
    public static final int DEPLOY = 3;
    public static String SCHEMA;
    public static String VERSION;
    public static String STORAGE;
    public static String PARTITIONING;
    public static String TABLESPACE;
    public static String TERM;
    public static String PRETTY;
    public static String BYTE;
    public static String FORCE;
    public static String ALTER;
    public static String DROP;
    public static String CASCADE;
    public static String GRANT;
    public static String DEPS;
    public static String CONS;
    public static String REF_CONS;
    public static String TRIG;
    public static String TRUNCATE;
    public static String GEN_SCHEMA;
    public static String GEN_CON;
    public static String GEN_CON_IDX;
    public static String GEN_REF_CON;
    public static String GEN_PASS;
    public static String IGN_PHYS;
    public static String IGN_SCHEMA;
    public static String MAINTAIN_SCHEMA;
    public static String IGN_SEG_ATTR;
    public static String IGN_STG;
    public static String IGN_TBL_COL_POS;
    public static String IGN_TABLESPACE;
    public static String MATCH_CONS_BY_NAME;
    public static String MATCH_CONS_BY_DEF;
    public static String RPT_CONS_NAME_DIFF;
    public static String STATS;
    public static String GEN_SQL_TERM;
    public static String GEN_COMMENTS;
    public static String IGN_PARTITIONING;
    public static String IGN_HIGH_VALUES;
    public static String LOG_COMPARE;
    public static String COMPATIBLE;
    public static String LATEST;
    private boolean _extractEnabled = true;
    private boolean _segments = false;
    private boolean _partitioning = true;
    private boolean _tablespace = true;
    private boolean _terminiator = true;
    private boolean _pretty = true;
    private boolean _byte = true;
    private boolean _force = true;
    private boolean _alter = false;
    private boolean _schema = true;
    private boolean _drop = false;
    private boolean _cascade = false;
    private boolean _grant = false;
    private boolean _dep = false;
    private boolean _constraint = true;
    private boolean _refConstraint = true;
    private boolean _trigger = true;
    private boolean _truncate = false;
    private String _version = COMPATIBLE;
    private boolean _generateSchema = true;
    private boolean _generateConstraints = true;
    private boolean _generateConstraintIndexes = true;
    private boolean _generateRefConstraints = true;
    private boolean _generatePasswordValue = true;
    private boolean _generateSQLTerminator = true;
    private boolean _generateComments = false;
    private boolean _ignorePhysicalAttributes = true;
    private boolean _ignoreSchema = true;
    private boolean _useOtherSchema = true;
    private boolean _ignoreSegmentAttributes = true;
    private boolean _ignoreStorage = true;
    private boolean _ignoreTableColumnPosition = true;
    private boolean _ignoreTablespace = true;
    private boolean _matchConstraintsByName = false;
    private boolean _reportConstraintNameDifferences = false;
    private boolean _statistics = false;
    private boolean _ignorePartitioning = false;
    private boolean _ignoreHighValues = false;
    private boolean _logicalCompare = true;
    private boolean _showExtractEnabled = true;
    private boolean _showSegments = false;
    private boolean _showPartitioning = false;
    private boolean _showTablespace = false;
    private boolean _showTerminiator = true;
    private boolean _showPretty = true;
    private boolean _showByte = true;
    private boolean _showForce = true;
    private boolean _showAlter = false;
    private boolean _showSchema = true;
    private boolean _showDrop = false;
    private boolean _showCascade = false;
    private boolean _showGrant = false;
    private boolean _showDep = false;
    private boolean _showConstraint = false;
    private boolean _showRefConstraint = false;
    private boolean _showTrigger = false;
    private boolean _showTruncate = false;
    private boolean _showVersion = false;
    private boolean _showGenerateSchema = false;
    private boolean _showGenerateConstraints = false;
    private boolean _showGenerateConstraintIndexes = false;
    private boolean _showGenerateRefConstraints = false;
    private boolean _showGeneratePasswordValue = false;
    private boolean _showGenerateSQLTerminator = false;
    private boolean _showGenerateComments = false;
    private boolean _showIgnorePhysicalAttributes = false;
    private boolean _showIgnoreSchema = false;
    private boolean _showIgnoreSegmentAttributes = false;
    private boolean _showIgnoreStorage = false;
    private boolean _showIgnoreTableColumnPosition = false;
    private boolean _showIgnoreTablespace = false;
    private boolean _showMatchConstraintsByName = false;
    private boolean _showReportConstraintNameDifferences = false;
    private boolean _showStatistics = false;
    private boolean _showIgnorePartitioning = false;
    private boolean _showIgnoreHighValues = false;
    private boolean _showLogicalCompare = false;
    private int _preference = 1;

    public DDLFormat() {
        this.initFormat();
    }

    public DDLFormat(int preference) {
        this._preference = preference;
        this.initFormat();
    }

    public int getPreference() {
        return this._preference;
    }

    public void setAllOptionsEnabled(boolean value) {
        this.setDDLOptionsEnabled(value);
        this.setCompareOptionsEnabled(value);
    }

    public void setDDLOptionsEnabled(boolean value) {
        this._extractEnabled = value;
        this._segments = value;
        this._partitioning = value;
        this._tablespace = value;
        this._terminiator = value;
        this._pretty = value;
        this._byte = value;
        this._force = value;
        this._alter = value;
        this._schema = value;
        this._drop = value;
        this._cascade = value;
        this._grant = value;
        this._dep = value;
        this._constraint = value;
        this._refConstraint = value;
        this._trigger = value;
        this._truncate = value;
    }

    public void setCompareOptionsEnabled(boolean value) {
        this._generateSchema = value;
        this._generateConstraints = value;
        this._generateConstraintIndexes = value;
        this._generateRefConstraints = value;
        this._generatePasswordValue = value;
        this._generateSQLTerminator = value;
        this._generateComments = value;
        this._ignorePhysicalAttributes = value;
        this._ignoreSchema = value;
        this._ignoreSegmentAttributes = value;
        this._ignoreStorage = value;
        this._ignoreTableColumnPosition = value;
        this._ignoreTablespace = value;
        this._matchConstraintsByName = value;
        this._reportConstraintNameDifferences = value;
        this._statistics = value;
        this._ignorePartitioning = value;
        this._ignoreHighValues = value;
        this._logicalCompare = value;
    }

    public void setShowDDLOptionsEnabled(boolean value) {
        this._showExtractEnabled = value;
        this._showSegments = value;
        this._showPartitioning = value;
        this._showTablespace = value;
        this._showTerminiator = value;
        this._showPretty = value;
        this._showByte = value;
        this._showForce = value;
        this._showAlter = value;
        this._showSchema = value;
        this._showDrop = value;
        this._showCascade = value;
        this._showGrant = value;
        this._showDep = value;
        this._showConstraint = value;
        this._showRefConstraint = value;
        this._showTrigger = value;
        this._showVersion = value;
    }

    public void setShowGenerateOptionsEnabled(boolean value) {
        this._showGenerateSchema = value;
        this._showGenerateConstraints = value;
        this._showGenerateConstraintIndexes = value;
        this._showGenerateRefConstraints = value;
        this._showGeneratePasswordValue = value;
        this._showGenerateSQLTerminator = value;
        this._showGenerateComments = value;
    }

    public void setShowCompareOptionsEnabled(boolean value) {
        this._showIgnorePhysicalAttributes = value;
        this._showIgnoreSchema = value;
        this._showIgnoreSegmentAttributes = value;
        this._showIgnoreStorage = value;
        this._showIgnoreTableColumnPosition = value;
        this._showIgnoreTablespace = value;
        this._showMatchConstraintsByName = value;
        this._showReportConstraintNameDifferences = value;
        this._showStatistics = value;
        this._showIgnorePartitioning = value;
        this._showIgnoreHighValues = value;
        this._showLogicalCompare = value;
    }

    public boolean isExtractEnabled() {
        return this._extractEnabled;
    }

    public void isExtractEnabled(boolean value) {
        this._extractEnabled = value;
    }

    public void setAlter(boolean alter) {
        this._alter = alter;
    }

    public void setDrop(boolean drop) {
        this._drop = drop;
    }

    public void setCascade(boolean cascade) {
        this._cascade = cascade;
    }

    public void setByte(boolean bytes) {
        this._byte = bytes;
    }

    public void setForce(boolean force) {
        this._force = force;
    }

    public void setPretty(boolean pretty) {
        this._pretty = pretty;
    }

    public void setSchema(boolean schema) {
        this._schema = schema;
    }

    public void setSegments(boolean segments) {
        this._segments = segments;
    }

    public void setPartitioning(boolean partitioning) {
        this._partitioning = partitioning;
    }

    public void setTablespace(boolean tablespace) {
        this._tablespace = tablespace;
    }

    public void setTerminiator(boolean terminiator) {
        this._terminiator = terminiator;
    }

    public void setGrant(boolean grant) {
        this._grant = grant;
    }

    public void setDep(boolean dep) {
        this._dep = dep;
    }

    public void setConstraint(boolean constraint) {
        this._constraint = constraint;
    }

    public void setRefConstraint(boolean refConstraint) {
        this._refConstraint = refConstraint;
    }

    public void setTrigger(boolean trigger) {
        this._trigger = trigger;
    }

    public void setTruncate(boolean truncate) {
        this._truncate = truncate;
    }

    public void setGenerateSchema(boolean value) {
        this._generateSchema = value;
    }

    public void setGenerateConstraints(boolean value) {
        this._generateConstraints = value;
    }

    public void setGenerateConstraintIndexes(boolean value) {
        this._generateConstraintIndexes = value;
    }

    public void setGenerateRefConstraints(boolean value) {
        this._generateRefConstraints = value;
    }

    public void setGeneratePasswordValue(boolean value) {
        this._generatePasswordValue = value;
    }

    public void setGenerateSQLTerminator(boolean value) {
        this._generateSQLTerminator = value;
    }

    public void setGenerateComments(boolean value) {
        this._generateComments = value;
    }

    public void setIgnorePhysicalAttributes(boolean value) {
        this._ignorePhysicalAttributes = value;
    }

    public void setIgnoreSchema(boolean value) {
        this._ignoreSchema = value;
    }

    public void setUseOtherSchema(boolean value) {
        this._useOtherSchema = value;
    }

    public void setIgnoreSegmentAttributes(boolean value) {
        this._ignoreSegmentAttributes = value;
    }

    public void setIgnoreStorage(boolean value) {
        this._ignoreStorage = value;
    }

    public void setIgnoreTableColumnPosition(boolean value) {
        this._ignoreTableColumnPosition = value;
    }

    public void setIgnoreTablespace(boolean value) {
        this._ignoreTablespace = value;
    }

    public void setMatchConstraintsByName(boolean value) {
        this._matchConstraintsByName = value;
    }

    public void setReportConstraintNameDifferences(boolean value) {
        this._reportConstraintNameDifferences = value;
    }

    public void setStatistics(boolean value) {
        this._statistics = value;
    }

    public void setIgnorePartitioning(boolean value) {
        this._ignorePartitioning = value;
    }

    public void setIgnoreHighValues(boolean value) {
        this._ignoreHighValues = value;
    }

    public void setLogicalCompare(boolean value) {
        this._logicalCompare = value;
    }

    public void setVersion(String value) {
        this._version = value;
    }

    public void setVersionDefault(String value) {
        this._version = COMPATIBLE;
    }

    public boolean getGrant() {
        return this._grant;
    }

    public boolean getAlter() {
        return this._alter;
    }

    public boolean getDrop() {
        return this._drop;
    }

    public boolean getCascade() {
        return this._cascade;
    }

    public boolean getByte() {
        return this._byte;
    }

    public boolean getForce() {
        return this._force;
    }

    public boolean getPretty() {
        return this._pretty;
    }

    public boolean getSchema() {
        return this._schema;
    }

    public boolean getSegments() {
        return this._segments;
    }

    public boolean getPartitioning() {
        return this._partitioning;
    }

    public boolean getTablespace() {
        return this._tablespace;
    }

    public boolean getTerminator() {
        return this._terminiator;
    }

    public boolean getDep() {
        return this._dep;
    }

    public boolean getConstraint() {
        return this._constraint;
    }

    public boolean getRefConstraint() {
        return this._refConstraint;
    }

    public boolean getTrigger() {
        return this._trigger;
    }

    public boolean getTruncate() {
        return this._truncate;
    }

    public boolean getGenerateSchema() {
        return this._generateSchema;
    }

    public boolean getGenerateConstraints() {
        return this._generateConstraints;
    }

    public boolean getGenerateConstraintIndexes() {
        return this._generateConstraintIndexes;
    }

    public boolean getGenerateRefConstraints() {
        return this._generateRefConstraints;
    }

    public boolean getGeneratePasswordValue() {
        return this._generatePasswordValue;
    }

    public boolean getGenerateSQLTerminator() {
        return this._generateSQLTerminator;
    }

    public boolean getGenerateComments() {
        return this._generateComments;
    }

    public boolean getIgnorePhysicalAttributes() {
        return this._ignorePhysicalAttributes;
    }

    public boolean getIgnoreSchema() {
        return this._ignoreSchema;
    }

    public boolean getUseOtherSchema() {
        return this._useOtherSchema;
    }

    public boolean getIgnoreSegmentAttributes() {
        return this._ignoreSegmentAttributes;
    }

    public boolean getIgnoreStorage() {
        return this._ignoreStorage;
    }

    public boolean getIgnoreTableColumnPosition() {
        return this._ignoreTableColumnPosition;
    }

    public boolean getIgnoreTablespace() {
        return this._ignoreTablespace;
    }

    public boolean getMatchConstraintsByName() {
        return this._matchConstraintsByName;
    }

    public boolean getReportConstraintNameDifferences() {
        return this._reportConstraintNameDifferences;
    }

    public boolean getStatistics() {
        return this._statistics;
    }

    public boolean getIgnorePartitioning() {
        return this._ignorePartitioning;
    }

    public boolean getIgnoreHighValues() {
        return this._ignoreHighValues;
    }

    public boolean getLogicalCompare() {
        return this._logicalCompare;
    }

    public String getVersion() {
        return this._version;
    }

    public boolean isShowExtractEnabled() {
        return this._showExtractEnabled;
    }

    public void isShowExtractEnabled(boolean value) {
        this._showExtractEnabled = value;
    }

    public void setShowAlter(boolean value) {
        this._showAlter = value;
    }

    public void setShowDrop(boolean value) {
        this._showDrop = value;
    }

    public void setShowCascade(boolean value) {
        this._showCascade = value;
    }

    public void setShowByte(boolean value) {
        this._showByte = value;
    }

    public void setShowForce(boolean value) {
        this._showForce = value;
    }

    public void setShowPretty(boolean value) {
        this._showPretty = value;
    }

    public void setShowSchema(boolean value) {
        this._showSchema = value;
    }

    public void setShowSegments(boolean value) {
        this._showSegments = value;
    }

    public void setShowPartitioning(boolean value) {
        this._showPartitioning = value;
    }

    public void setShowTablespace(boolean value) {
        this._showTablespace = value;
    }

    public void setShowTerminiator(boolean value) {
        this._showTerminiator = value;
    }

    public void setShowGrant(boolean value) {
        this._showGrant = value;
    }

    public void setShowDep(boolean value) {
        this._showDep = value;
    }

    public void setShowConstraint(boolean value) {
        this._showConstraint = value;
    }

    public void setShowRefConstraint(boolean value) {
        this._showRefConstraint = value;
    }

    public void setShowTrigger(boolean value) {
        this._showTrigger = value;
    }

    public void setShowTruncate(boolean value) {
        this._showTruncate = value;
    }

    public void setShowVersion(boolean value) {
        this._showVersion = value;
    }

    public void setShowGenerateSchema(boolean value) {
        this._showGenerateSchema = value;
    }

    public void setShowGenerateConstraints(boolean value) {
        this._showGenerateConstraints = value;
    }

    public void setShowGenerateConstraintIndexes(boolean value) {
        this._showGenerateConstraintIndexes = value;
    }

    public void setShowGenerateRefConstraints(boolean value) {
        this._showGenerateRefConstraints = value;
    }

    public void setShowGeneratePasswordValue(boolean value) {
        this._showGeneratePasswordValue = value;
    }

    public void setShowGenerateSQLTerminator(boolean value) {
        this._showGenerateSQLTerminator = value;
    }

    public void setShowGenerateComments(boolean value) {
        this._showGenerateComments = value;
    }

    public void setShowIgnorePhysicalAttributes(boolean value) {
        this._showIgnorePhysicalAttributes = value;
    }

    public void setShowIgnoreSchema(boolean value) {
        this._showIgnoreSchema = value;
    }

    public void setShowIgnoreSegmentAttributes(boolean value) {
        this._showIgnoreSegmentAttributes = value;
    }

    public void setShowIgnoreStorage(boolean value) {
        this._showIgnoreStorage = value;
    }

    public void setShowIgnoreTableColumnPosition(boolean value) {
        this._showIgnoreTableColumnPosition = value;
    }

    public void setShowIgnoreTablespace(boolean value) {
        this._showIgnoreTablespace = value;
    }

    public void setShowMatchConstraintsByName(boolean value) {
        this._showMatchConstraintsByName = value;
    }

    public void setShowReportConstraintNameDifferences(boolean value) {
        this._showReportConstraintNameDifferences = value;
    }

    public void setShowStatistics(boolean value) {
        this._showStatistics = value;
    }

    public void setShowIgnorePartioning(boolean value) {
        this._showIgnorePartitioning = value;
    }

    public void setShowIgnoreHighValues(boolean value) {
        this._showIgnoreHighValues = value;
    }

    public void setShowLogicalCompare(boolean value) {
        this._showLogicalCompare = value;
    }

    public boolean getShowGrant() {
        return this._showGrant;
    }

    public boolean getShowAlter() {
        return this._showAlter;
    }

    public boolean getShowDrop() {
        return this._showDrop;
    }

    public boolean getShowCascade() {
        return this._showCascade;
    }

    public boolean getShowByte() {
        return this._showByte;
    }

    public boolean getShowForce() {
        return this._showForce;
    }

    public boolean getShowPretty() {
        return this._showPretty;
    }

    public boolean getShowSchema() {
        return this._showSchema;
    }

    public boolean getShowSegments() {
        return this._showSegments;
    }

    public boolean getShowPartitioning() {
        return this._showPartitioning;
    }

    public boolean getShowTablespace() {
        return this._showTablespace;
    }

    public boolean getShowTerminator() {
        return this._showTerminiator;
    }

    public boolean getShowDep() {
        return this._showDep;
    }

    public boolean getShowConstraint() {
        return this._showConstraint;
    }

    public boolean getShowRefConstraint() {
        return this._showRefConstraint;
    }

    public boolean getShowTrigger() {
        return this._showTrigger;
    }

    public boolean getShowTruncate() {
        return this._showTruncate;
    }

    public boolean getShowVersion() {
        return this._showVersion;
    }

    public boolean getShowGenerateSchema() {
        return this._showGenerateSchema;
    }

    public boolean getShowGenerateConstraints() {
        return this._showGenerateConstraints;
    }

    public boolean getShowGenerateConstraintIndexes() {
        return this._showGenerateConstraintIndexes;
    }

    public boolean getShowGenerateRefConstraints() {
        return this._showGenerateRefConstraints;
    }

    public boolean getShowGeneratePasswordValue() {
        return this._showGeneratePasswordValue;
    }

    public boolean getShowGenerateSQLTerminator() {
        return this._showGenerateSQLTerminator;
    }

    public boolean getShowGenerateComments() {
        return this._showGenerateComments;
    }

    public boolean getShowIgnorePhysicalAttributes() {
        return this._showIgnorePhysicalAttributes;
    }

    public boolean getShowIgnoreSchema() {
        return this._showIgnoreSchema;
    }

    public boolean getShowIgnoreSegmentAttributes() {
        return this._showIgnoreSegmentAttributes;
    }

    public boolean getShowIgnoreStorage() {
        return this._showIgnoreStorage;
    }

    public boolean getShowIgnoreTableColumnPosition() {
        return this._showIgnoreTableColumnPosition;
    }

    public boolean getShowIgnoreTablespace() {
        return this._showIgnoreTablespace;
    }

    public boolean getShowMatchConstraintsByName() {
        return this._showMatchConstraintsByName;
    }

    public boolean getShowReportConstraintNameDifferences() {
        return this._showReportConstraintNameDifferences;
    }

    public boolean getShowStatistics() {
        return this._showStatistics;
    }

    public boolean getShowIgnorePartitioning() {
        return this._showIgnorePartitioning;
    }

    public boolean getShowIgnoreHighValues() {
        return this._showIgnoreHighValues;
    }

    public boolean getShowLogicalCompare() {
        return this._showLogicalCompare;
    }

    private void initFormat() {
        this.initFormat(ICommonConfig.Storage.getInstance());
    }

    public void initFormat(IStorage config) {
        if (this._preference != 3) {
            Boolean x = config.getBoolean("EXPORT_DDL_ENABLED");
            if (x != null) {
                this._extractEnabled = x;
            }
            if ((x = config.getBoolean("DDL_SEGMENTS")) != null) {
                this._segments = x;
            }
            if ((x = config.getBoolean("EXPORT_PARTITIONING")) != null) {
                this._partitioning = x;
            }
            if ((x = config.getBoolean("EXPORT_TABLESPACE")) != null) {
                this._tablespace = x;
            }
            if ((x = config.getBoolean("DDL_TERMINATOR")) != null) {
                this._terminiator = x;
            }
            if ((x = config.getBoolean("DDL_PRETTY")) != null) {
                this._pretty = x;
            }
            if ((x = config.getBoolean("DDL_BYTE")) != null) {
                this._byte = x;
            }
            if ((x = config.getBoolean("DDL_FORCE")) != null) {
                this._force = x;
            }
            if ((x = config.getBoolean("DDL_ALTER")) != null) {
                this._alter = x;
            }
            if ((x = config.getBoolean("DDL_SCHEMA")) != null) {
                this._schema = x;
            }
            this._version = config.getString("DDL_VERSION");
            if (this._version == null) {
                this._version = COMPATIBLE;
            }
            if ((x = config.getBoolean("EXPORT_DROP")) != null) {
                this._drop = x;
            }
            if ((x = config.getBoolean("EXPORT_CASCADE")) != null) {
                this._cascade = x;
            }
            if ((x = config.getBoolean("EXPORT_GRANT")) != null) {
                this._grant = x;
            }
            if ((x = config.getBoolean("EXPORT_DEP")) != null) {
                this._dep = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_SCHEMA")) != null) {
                this._generateSchema = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_CONSTRAINT")) != null) {
                this._generateConstraints = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_CONSTRAINT_INDEXES")) != null) {
                this._generateConstraintIndexes = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_REF_CONSTRAINTS")) != null) {
                this._generateRefConstraints = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_PASS_VALUE")) != null) {
                this._generatePasswordValue = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_SQL_TERM")) != null) {
                this._generateSQLTerminator = x;
            }
            if ((x = config.getBoolean("DIFF_GEN_COMMENTS")) != null) {
                this._generateComments = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_PHYSICAL")) != null) {
                this._ignorePhysicalAttributes = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_SCHEMA")) != null) {
                this._ignoreSchema = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_SEGMENTS")) != null) {
                this._ignoreSegmentAttributes = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_STORAGE")) != null) {
                this._ignoreStorage = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_TBL_COL_POS")) != null) {
                this._ignoreTableColumnPosition = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_TABLESPACE")) != null) {
                this._ignoreTablespace = x;
            }
            if ((x = config.getBoolean("DIFF_MATCH_CONSTRAINTS_NAME")) != null) {
                this._matchConstraintsByName = x;
            }
            if ((x = config.getBoolean("DIFF_RPT_CONSTRAINT_NAME")) != null) {
                this._reportConstraintNameDifferences = x;
            }
            if ((x = config.getBoolean("DIFF_STATISTICS")) != null) {
                this._statistics = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_PARTITIONING")) != null) {
                this._ignorePartitioning = x;
            }
            if ((x = config.getBoolean("DIFF_IGN_HIGH_VALUES")) != null) {
                this._ignoreHighValues = x;
            }
            if ((x = config.getBoolean("DIFF_LOG_COMPARE")) != null) {
                this._logicalCompare = x;
            }
        } else {
            Boolean x = config.getBoolean("DEPLOY_DDL_SEGMENTS");
            if (x != null) {
                this._segments = x;
            }
            if ((x = config.getBoolean("DEPLOY_DDL_PARTITIONING")) != null) {
                this._partitioning = x;
            }
            if ((x = config.getBoolean("DEPLOY_DDL_TABLESPACE")) != null) {
                this._tablespace = x;
            }
            if ((x = config.getBoolean("DEPLOY_DDL_TERMINATOR")) != null) {
                this._terminiator = x;
            }
            if ((x = config.getBoolean("DEPLOY_DDL_PRETTY")) != null) {
                this._pretty = x;
            }
            if ((x = config.getBoolean("DEPLOY_DDL_BYTE")) != null) {
                this._byte = x;
            }
            if ((x = config.getBoolean("DEPLOY_DDL_FORCE")) != null) {
                this._force = x;
            }
            x = config.getBoolean("DEPLOY_DDL_SCHEMA");
            this._version = config.getString("DEPLOY_DDL_VERSION");
            if (this._version == null) {
                this._version = COMPATIBLE;
            }
            if (x != null) {
                this._schema = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_DROP")) != null) {
                this._drop = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_CASCADE")) != null) {
                this._cascade = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_GRANT")) != null) {
                this._grant = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_DEP")) != null) {
                this._dep = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_CONSTS")) != null) {
                this._constraint = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_REF_CONSTS")) != null) {
                this._refConstraint = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_TRIGGERS")) != null) {
                this._trigger = x;
            }
            if ((x = config.getBoolean("DEPLOY_EXPORT_TRUNCATE")) != null) {
                this._truncate = x;
            }
        }
    }

    public void saveFormat(IStorage config) {
        if (this._preference != 3) {
            if (this._showExtractEnabled) {
                config.putBoolean("EXPORT_DDL_ENABLED", this.isExtractEnabled());
            }
            if (this._showSegments) {
                config.putBoolean("DDL_SEGMENTS", this.getSegments());
            }
            if (this._showPartitioning) {
                config.putBoolean("EXPORT_PARTITIONING", this.getPartitioning());
            }
            if (this._showTablespace) {
                config.putBoolean("EXPORT_TABLESPACE", this.getTablespace());
            }
            if (this._showTerminiator) {
                config.putBoolean("DDL_TERMINATOR", this.getTerminator());
            }
            if (this._showPretty) {
                config.putBoolean("DDL_PRETTY", this.getPretty());
            }
            if (this._showByte) {
                config.putBoolean("DDL_BYTE", this.getByte());
            }
            if (this._showForce) {
                config.putBoolean("DDL_FORCE", this.getForce());
            }
            if (this._showAlter) {
                config.putBoolean("DDL_ALTER", this.getAlter());
            }
            if (this._showSchema) {
                config.putBoolean("DDL_SCHEMA", this.getSchema());
            }
            if (this._showDrop) {
                config.putBoolean("EXPORT_DROP", this.getDrop());
            }
            if (this._showCascade) {
                config.putBoolean("EXPORT_CASCADE", this.getCascade());
            }
            if (this._showVersion) {
                config.putString("DDL_VERSION", this.getVersion());
            }
            if (this._showGrant) {
                config.putBoolean("EXPORT_GRANT", this.getGrant());
            }
            if (this._showDep) {
                config.putBoolean("EXPORT_DEP", this.getDep());
            }
            if (this._showGenerateSchema) {
                config.putBoolean("DIFF_GEN_SCHEMA", this.getGenerateSchema());
            }
            if (this._showGenerateConstraints) {
                config.putBoolean("DIFF_GEN_CONSTRAINT", this.getGenerateConstraints());
            }
            if (this._showGenerateConstraintIndexes) {
                config.putBoolean("DIFF_GEN_CONSTRAINT_INDEXES", this.getGenerateConstraintIndexes());
            }
            if (this._showGenerateRefConstraints) {
                config.putBoolean("DIFF_GEN_REF_CONSTRAINTS", this.getGenerateRefConstraints());
            }
            if (this._showGeneratePasswordValue) {
                config.putBoolean("DIFF_GEN_PASS_VALUE", this.getGeneratePasswordValue());
            }
            if (this._showGenerateSQLTerminator) {
                config.putBoolean("DIFF_GEN_SQL_TERM", this.getGenerateSQLTerminator());
            }
            if (this._showGenerateComments) {
                config.putBoolean("DIFF_GEN_COMMENTS", this.getGenerateComments());
            }
            if (this._showIgnorePhysicalAttributes) {
                config.putBoolean("DIFF_IGN_PHYSICAL", this.getIgnorePhysicalAttributes());
            }
            if (this._showIgnoreSchema) {
                config.putBoolean("DIFF_IGN_SCHEMA", this.getIgnoreSchema());
            }
            if (this._showIgnoreSegmentAttributes) {
                config.putBoolean("DIFF_IGN_SEGMENTS", this.getIgnoreSegmentAttributes());
            }
            if (this._showIgnoreStorage) {
                config.putBoolean("DIFF_IGN_STORAGE", this.getIgnoreStorage());
            }
            if (this._showIgnoreTableColumnPosition) {
                config.putBoolean("DIFF_IGN_TBL_COL_POS", this.getIgnoreTableColumnPosition());
            }
            if (this._showIgnoreTablespace) {
                config.putBoolean("DIFF_IGN_TABLESPACE", this.getIgnoreTablespace());
            }
            if (this._showMatchConstraintsByName) {
                config.putBoolean("DIFF_MATCH_CONSTRAINTS_NAME", this.getMatchConstraintsByName());
            }
            if (this._showReportConstraintNameDifferences) {
                config.putBoolean("DIFF_RPT_CONSTRAINT_NAME", this.getReportConstraintNameDifferences());
            }
            if (this._showStatistics) {
                config.putBoolean("DIFF_STATISTICS", this.getStatistics());
            }
            if (this._showIgnorePartitioning) {
                config.putBoolean("DIFF_IGN_PARTITIONING", this.getIgnorePartitioning());
            }
            if (this._showIgnoreHighValues) {
                config.putBoolean("DIFF_IGN_HIGH_VALUES", this.getIgnoreHighValues());
            }
            if (this._showLogicalCompare) {
                config.putBoolean("DIFF_LOG_COMPARE", this.getLogicalCompare());
            }
        } else {
            if (this._showSegments) {
                config.putBoolean("DEPLOY_DDL_SEGMENTS", this.getSegments());
            }
            if (this._showPartitioning) {
                config.putBoolean("DEPLOY_DDL_PARTITIONING", this.getPartitioning());
            }
            if (this._showSegments) {
                config.putBoolean("DEPLOY_DDL_TABLESPACE", this.getTablespace());
            }
            if (this._showTerminiator) {
                config.putBoolean("DEPLOY_DDL_TERMINATOR", this.getTerminator());
            }
            if (this._showPretty) {
                config.putBoolean("DEPLOY_DDL_PRETTY", this.getPretty());
            }
            if (this._showByte) {
                config.putBoolean("DEPLOY_DDL_BYTE", this.getByte());
            }
            if (this._showForce) {
                config.putBoolean("DEPLOY_DDL_FORCE", this.getForce());
            }
            if (this._showSchema) {
                config.putBoolean("DEPLOY_DDL_SCHEMA", this.getSchema());
            }
            if (this._showVersion) {
                config.putString("DEPLOY_DDL_VERSION", this.getVersion());
            }
            if (this._showDrop) {
                config.putBoolean("DEPLOY_EXPORT_DROP", this.getDrop());
            }
            if (this._showCascade) {
                config.putBoolean("DEPLOY_EXPORT_CASCADE", this.getCascade());
            }
            if (this._showGrant) {
                config.putBoolean("DEPLOY_EXPORT_GRANT", this.getGrant());
            }
            if (this._showDep) {
                config.putBoolean("DEPLOY_EXPORT_DEP", this.getDep());
            }
            if (this._showConstraint) {
                config.putBoolean("DEPLOY_EXPORT_CONSTS", this.getConstraint());
            }
            if (this._showRefConstraint) {
                config.putBoolean("DEPLOY_EXPORT_REF_CONSTS", this.getRefConstraint());
            }
            if (this._showTrigger) {
                config.putBoolean("DEPLOY_EXPORT_TRIGGERS", this.getTrigger());
            }
            if (this._showTruncate) {
                config.putBoolean("DEPLOY_EXPORT_TRUNCATE", this.getTruncate());
            }
        }
    }

    static {
        DDLFormatConfig.DefaultInitializer.init();
        SCHEMA = "SCHEMA";
        VERSION = "VERSION";
        STORAGE = "STORAGE";
        PARTITIONING = "PARTITIONING";
        TABLESPACE = "TABLESPACE";
        TERM = "TERM";
        PRETTY = "PRETTY";
        BYTE = "BYTE";
        FORCE = "FORCE";
        ALTER = "ALTER";
        DROP = "DROP";
        CASCADE = "CASCADE";
        GRANT = "GRANT";
        DEPS = "DEPS";
        CONS = "CON";
        REF_CONS = "REF_CON";
        TRIG = "TRIG";
        TRUNCATE = "TRUNCATE";
        GEN_SCHEMA = "GEN_SCHEMA";
        GEN_CON = "GEN_CON";
        GEN_CON_IDX = "GEN_CON_IDX";
        GEN_REF_CON = "GEN_REF_CON";
        GEN_PASS = "GEN_PASS";
        IGN_PHYS = "IGN_PHYS";
        IGN_SCHEMA = "CONSOLIDATE_SCHEMA";
        MAINTAIN_SCHEMA = "MAINTAIN_SCHEMA";
        IGN_SEG_ATTR = "IGN_SEG_ATTR";
        IGN_STG = "IGN_STG";
        IGN_TBL_COL_POS = "IGN_TBL_COL_POS";
        IGN_TABLESPACE = "IGN_TABLESPACE";
        MATCH_CONS_BY_NAME = "MATCH_CONS_BY_NAME";
        MATCH_CONS_BY_DEF = "MATCH_CONS_BY_DEF";
        RPT_CONS_NAME_DIFF = "RPT_CONS_NAME_DIFF";
        STATS = "STATS";
        GEN_SQL_TERM = "GEN_SQL_TERM";
        GEN_COMMENTS = "GEN_COMMENTS";
        IGN_PARTITIONING = "IGN_PARTITIONING";
        IGN_HIGH_VALUES = "IGN_HIGH_VALUES";
        LOG_COMPARE = "LOG_COMPARE";
        COMPATIBLE = "COMPATIBLE";
        LATEST = "LATEST";
    }
}

