/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.cmdline;

import oracle.dbtools.common.ddl.TargetFormat;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.export.ExportResources;
import oracle.dbtools.export.service.ExportAPI;
import oracle.dbtools.export.service.ExportParms;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.utils.IToolRunMode;
import oracle.dbtools.util.Logger;

public class ExportCL
extends ExportAPI {
    private ExportParms _eParms;
    private String _encoding;

    public ExitCode start(ExportParms eParms) {
        try {
            this._eParms = eParms;
            IToolRunMode tRunMode = eParms.getToolRunMode();
            ExitCode exitCode = super.start(eParms, tRunMode);
            ExportService eService = this.getService();
            eService.initELogger();
            return exitCode;
        }
        catch (Exception e) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + e.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    @Override
    public void export() {
        final ExportService eService = this.getService();
        TargetFormat targetFormat = eService.getTargetFormat();
        IRaptorTaskRunMode mode = IRaptorTaskRunMode.NO_GUI;
        String unloadTo = targetFormat.getSaveAsType() < 4 ? targetFormat.getSaveAs() : targetFormat.getSaveAsTypeString();
        String msg = ExportResources.format("UNLOADING", unloadTo);
        eService.isCancel(false);
        RaptorTask<Void> task = new RaptorTask<Void>(msg, true, mode){

            public Void doWork() {
                try {
                    eService.startGenOutput();
                    ExitCode exitCode = eService.validate();
                    if (exitCode != ExitCode.EXIT_SUCCESS) {
                        eService.getGenOutput().println(exitCode.getMessage());
                        eService.isCancel(true);
                    } else {
                        eService.export();
                    }
                }
                catch (Exception e1) {
                    Logger.warn(ExportAPI.class, (Throwable)e1);
                    eService.eLogException(e1);
                }
                finally {
                    try {
                        eService.getGenOutput().finished();
                        ExportCL.this.finish();
                    }
                    catch (Exception e) {
                        Logger.warn(ExportAPI.class, (Throwable)e);
                        eService.eLogException(e);
                    }
                }
                return null;
            }

            public boolean cancel() {
                eService.isCancel(true);
                return true;
            }

            public String getConnectionName() {
                return eService.getConnName();
            }

            public String getQuery() {
                return "";
            }
        };
        task.setCancellable(true);
        ExportTaskListener listener = new ExportTaskListener();
        task.getDescriptor().addListener((IRaptorTaskListener)listener);
        RaptorTaskManager.getInstance().addTask((RaptorTask)task);
        this.getRunMode().setTask((RaptorTask)task);
        try {
            listener.waitForDone();
            this.getRunMode().setTask(null);
        }
        catch (Exception e) {
            Logger.warn(ExportAPI.class, (Throwable)e);
        }
    }

    public ExitCode run(ExportParms eParms) {
        try {
            ExitCode exitCode = this.start(eParms);
            if (!(exitCode != ExitCode.EXIT_SUCCESS && exitCode != ExitCode.EXIT_WARNING || (exitCode = this.validate()) != ExitCode.EXIT_SUCCESS && exitCode != ExitCode.EXIT_WARNING)) {
                this.export();
            }
            return exitCode;
        }
        catch (Exception e) {
            ExitCode exitCode = ExitCode.EXIT_SEVERE;
            exitCode.setMessage(exitCode.getMessage() + " " + e.toString());
            return ExitCode.EXIT_SEVERE;
        }
    }

    protected String getLineTerminator() {
        return System.getProperty("line.separator");
    }

    private class ExportTaskListener
    extends RaptorTaskAdapter {
        private boolean done;

        private ExportTaskListener() {
        }

        public void done() {
            this.done = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void waitForDone() throws InterruptedException {
            while (!this.isDone()) {
                Thread.sleep(250L);
            }
        }

        public void taskFinished(RaptorTaskEvent event) {
            try {
                ExportService eService = ExportCL.this.getService();
                eService.eLogToolEnd();
                eService.getELogger().flushLog();
            }
            catch (Exception e) {
                Logger.warn(ExportAPI.class, (Throwable)e);
            }
            finally {
                this.done();
            }
        }

        public void taskCancelled(RaptorTaskEvent event) {
            try {
                ExportService eService = ExportCL.this.getService();
                eService.isCancel(true);
                eService.taskCancelledServiceProcess();
                eService.eLog(ExportResources.getString("EXPORT_CANCEL"));
                eService.eLogToolEnd();
                eService.eLogFinish();
            }
            catch (Exception e) {
                Logger.warn(ExportAPI.class, (Throwable)e);
            }
            finally {
                this.done();
            }
        }

        public void taskFailed(RaptorTaskEvent event) {
            try {
                ExportService eService = ExportCL.this.getService();
                eService.isCancel(true);
                eService.taskFailedServiceProcess();
                eService.eLogException(event.getThrowable());
                eService.eLog(ExportResources.getString("EXPORT_FAILED"));
                eService.eLogToolEnd();
                eService.eLogFinish();
            }
            catch (Exception e) {
                Logger.warn(ExportAPI.class, (Throwable)e);
            }
            finally {
                this.done();
            }
        }
    }
}

