/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mle.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.mle.command.MLEMessages;
import oracle.dbtools.extension.mle.command.MLESymbols;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.Service;

public class MLEEngine {
    public static final String defaultLanguage = "javascript";
    private final ScriptRunnerContext ctx;
    private final Connection conn;
    private final ParsedCommand prscmd;
    private String schemaName;
    private String moduleName;
    private String codeFileName;
    private String bundler;
    private String bundlerCfg;
    private String sbomCmd;
    private Boolean isReplace = false;
    private Boolean ifNotExists = false;
    private Boolean ifExists = false;
    private String language = "javascript";
    private String version;
    private String metadata;
    private DBUtil dbUtil;
    private boolean verbose;

    public MLEEngine(ScriptRunnerContext context, Connection connection, ParsedCommand parsedCommand) {
        this.ctx = context;
        this.conn = connection;
        this.prscmd = parsedCommand;
        if (this.prscmd != null) {
            this.schemaName = (String)this.prscmd.getOptionValue((Id)MLESymbols.SCHEMA);
            this.moduleName = (String)this.prscmd.getOptionValue((Id)MLESymbols.MODULE_NAME);
            this.verbose = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.VERBOSE);
        }
    }

    public MLEEngine(ScriptRunnerContext ctx, Connection connection) {
        this(ctx, connection, null);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public void setCodeFileName(String codeFileName) {
        this.codeFileName = codeFileName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void executeCreateCommand() {
        this.codeFileName = FileUtils.getContextFile((ScriptRunnerContext)this.ctx, (String)((String)this.prscmd.getOptionValue((Id)MLESymbols.FILENAME))).toString();
        this.bundler = (String)this.prscmd.getOptionValue((Id)MLESymbols.BUNDLER);
        String bundlerCfgFilename = (String)this.prscmd.getOptionValue((Id)MLESymbols.BUNDLER_CONFIG);
        this.bundlerCfg = bundlerCfgFilename == null ? null : FileUtils.getContextFile((ScriptRunnerContext)this.ctx, (String)bundlerCfgFilename).toString();
        this.isReplace = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.REPLACE);
        this.ifNotExists = (Boolean)this.prscmd.getOptionValue((Id)MLESymbols.IF_NOT_EXISTS);
        this.ifExists = false;
        this.language = (String)this.prscmd.getOptionValue((Id)MLESymbols.LANGUAGE);
        this.version = (String)this.prscmd.getOptionValue((Id)MLESymbols.VERSION);
        this.sbomCmd = (String)this.prscmd.getOptionValue((Id)MLESymbols.SBOM);
        try {
            this.checkForMeta(true, true);
            this.executeCreate();
            if (this.metadata != null) {
                this.executeAlter();
            }
        }
        catch (Throwable ex) {
            this.ctx.writeln(ex.getMessage());
        }
    }

    private void checkForMeta(boolean nullok, boolean isCreate) throws Exception {
        this.metadata = (String)this.prscmd.getOptionValue((Id)MLESymbols.METADATA);
        String metaFileName = (String)this.prscmd.getOptionValue((Id)MLESymbols.METAFILE);
        metaFileName = metaFileName == null ? null : FileUtils.getContextFile((ScriptRunnerContext)this.ctx, (String)metaFileName).toString();
        int i = 0;
        if (this.metadata != null) {
            ++i;
        }
        if (metaFileName != null) {
            i += 2;
        }
        if (this.sbomCmd != null) {
            i += 4;
        }
        switch (i) {
            case 0: {
                if (nullok) break;
                throw new IllegalArgumentException(MLEMessages.get(isCreate ? "META_REQ_SBOM_ERR" : "META_REQ_ERR"));
            }
            case 1: {
                break;
            }
            case 2: {
                this.metadata = Service.readFile((String)metaFileName);
                break;
            }
            case 4: {
                this.metadata = this.getSBOM();
                break;
            }
            default: {
                throw new IllegalArgumentException(MLEMessages.get(isCreate ? "META_EXCL_SBOM_ERR" : "META_EXCL_ERR"));
            }
        }
    }

    public void executeAlterCommand() {
        try {
            this.checkForMeta(false, false);
            this.executeAlter();
        }
        catch (Throwable ex) {
            this.ctx.writeln(ex.getMessage());
        }
    }

    private void executeRollup(String ofile) throws Exception {
        String out;
        this.verboseLog("PATH", System.getenv("PATH"));
        ArrayList<String> alargs = new ArrayList<String>();
        alargs.add("rollup");
        if (!this.verbose) {
            alargs.add("--silent");
        }
        if (this.bundlerCfg != null) {
            alargs.add("-c");
            alargs.add(this.bundlerCfg);
        }
        alargs.add("-o");
        alargs.add(ofile);
        alargs.add(this.codeFileName);
        ProcessBuilder pb = new ProcessBuilder(alargs);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            out = rdr.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        p.waitFor();
        if (this.verbose || !out.isEmpty() || p.exitValue() != 0) {
            this.verboseLogAttr("rollup command", String.join((CharSequence)" ", alargs.toString()));
            this.verboseLogAttr("rollup exit value", "" + p.exitValue());
            this.verboseLogAttr("rollup console output", out);
        }
        if (p.exitValue() != 0) {
            String useverb = this.verbose ? "" : ". " + MLEMessages.format("USE_VERBOSE", new Object[0]);
            throw new Exception(MLEMessages.format("ROLLUP_FAILED", p.exitValue(), useverb));
        }
    }

    private void resolveBundling() throws Exception {
        if (this.bundler == null) {
            if (this.bundlerCfg != null) {
                throw new IllegalArgumentException(MLEMessages.format("BUNDLER_OPTS", new Object[0]));
            }
            return;
        }
        String tmp = File.createTempFile("MLE-", ".js").getAbsolutePath();
        this.verboseLog("bundler input", this.codeFileName);
        this.verboseLog("bundler output", tmp);
        this.executeRollup(tmp);
        this.codeFileName = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mleUsingString(String cmd, String datatype, String str, boolean checkJson) throws Exception {
        String tempTableName = "\"MLE_" + String.valueOf(UUID.randomUUID()) + "\"";
        boolean tempTableCreated = false;
        try {
            String tempTableStatement = String.format("create table %s (CODE %s)", tempTableName, datatype);
            try {
                this.executeDDL(tempTableStatement);
            }
            catch (SQLException ex) {
                throw new SQLException(MLEMessages.format("TMPTAB_CREATE_FAILED", ex.getMessage()));
            }
            tempTableCreated = true;
            String insertTableStatement = "insert into " + tempTableName + " (CODE) values (:code)";
            this.verboseLog(insertTableStatement);
            try (PreparedStatement stm = this.conn.prepareStatement(insertTableStatement);){
                if (datatype.contentEquals("blob")) {
                    Blob blob = this.conn.createBlob();
                    blob.setBytes(1L, str.getBytes(StandardCharsets.UTF_8));
                    stm.setBlob(1, blob);
                } else {
                    stm.setString(1, str);
                }
                stm.execute();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(MLEMessages.format("INSERT_FAILED", ex.getMessage()));
            }
            String expr = checkJson ? "json(CODE)" : "CODE";
            String sb = cmd + String.format(" using %s (select %s from %s)", datatype, expr, tempTableName);
            this.executeDDL(sb);
        }
        finally {
            if (tempTableCreated) {
                this.executeDDL("drop table " + tempTableName);
            }
        }
    }

    private void mleUsingFile(String cmd, String dtype, String filename, boolean checkJson) throws Exception {
        this.verboseLogAttr("filename", filename);
        File codeFile = new File(filename);
        if (codeFile.length() == 0L) {
            throw new IllegalArgumentException(MLEMessages.format("MOD_FILE_EMPTY", filename));
        }
        String str = Service.readFile((String)filename);
        this.mleUsingString(cmd, dtype, str, checkJson);
    }

    public void executeCreate() throws Exception {
        this.requires23();
        this.resolveBundling();
        StringBuilder sb = new StringBuilder("create ");
        if (this.isReplace.booleanValue()) {
            sb.append("or replace ");
        }
        sb.append("mle module ");
        if (this.ifNotExists.booleanValue()) {
            sb.append("if not exists ");
        }
        if (this.schemaName != null) {
            this.verboseLogAttr("schema", this.schemaName);
        }
        this.verboseLogAttr("name", this.moduleName);
        sb.append(this.getObjectReference());
        sb.append(" language ");
        this.verboseLogAttr("language", this.language);
        sb.append(this.language);
        if (this.version != null) {
            sb.append(" version '");
            this.verboseLogAttr("version", this.version);
            sb.append(this.version);
            sb.append("'");
        }
        try {
            this.mleUsingFile(sb.toString(), "blob", this.codeFileName, false);
            String warnings = this.getCompilationErrors(this.schemaName, this.moduleName);
            if (warnings.isEmpty()) {
                this.ctx.writeln(MLEMessages.format("MOD_CREATED", this.getObjectReference()));
            } else {
                this.ctx.writeln(MLEMessages.format("MOD_WARNINGS", this.getObjectReference(), System.lineSeparator(), warnings));
            }
        }
        catch (Throwable ex) {
            this.ctx.writeln(MLEMessages.format("MOD_NOT_CREATED", this.getObjectReference(), ex));
        }
    }

    private void requires23() throws Exception {
        if (this.conn == null || this.conn.isClosed()) {
            throw new IllegalArgumentException(ScriptRunnerDbArb.getString((String)"NOT_CONNECTED"));
        }
        this.dbUtil = DBUtil.getInstance((Connection)this.conn);
        DatabaseMetaData md = this.conn.getMetaData();
        if (md.getDatabaseMajorVersion() < 23) {
            throw new IllegalArgumentException(MLEMessages.format("NO_MLE_SUPPORT", md.getDatabaseMajorVersion(), 23));
        }
    }

    public void executeAlter() throws Exception {
        this.requires23();
        StringBuilder sb = new StringBuilder("alter mle module ");
        if (this.ifExists.booleanValue()) {
            sb.append("if exists ");
        }
        if (this.schemaName != null) {
            this.verboseLogAttr("schema", this.schemaName);
        }
        this.verboseLogAttr("name", this.moduleName);
        sb.append(this.getObjectReference());
        sb.append(" set metadata ");
        try {
            this.mleUsingString(sb.toString(), "clob", this.metadata, true);
            this.ctx.writeln(MLEMessages.format("MOD_ALTERED", this.getObjectReference()));
        }
        catch (Throwable ex) {
            this.ctx.writeln(MLEMessages.format("MOD_NOT_ALTERED", this.getObjectReference(), ex.getMessage()));
        }
    }

    private String getSBOM() throws Exception {
        this.verboseLog("PATH", System.getenv("PATH"));
        ArrayList<String> alargs = new ArrayList<String>();
        alargs.add(this.sbomCmd);
        alargs.add("--output");
        alargs.add("cyclonedx-json");
        alargs.add(this.codeFileName);
        ProcessBuilder pb = new ProcessBuilder(alargs);
        Process p = pb.start();
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(p.getInputStream());
             BufferedReader rdr = new BufferedReader(isr);){
            String line;
            while ((line = rdr.readLine()) != null) {
                sb.append(line);
                sb.append(System.lineSeparator());
            }
        }
        p.waitFor();
        if (this.verbose || p.exitValue() != 0) {
            this.verboseLogAttr("sbom command", String.join((CharSequence)" ", alargs.toString()));
            this.verboseLogAttr("sbom command exit value", "" + p.exitValue());
        }
        if (p.exitValue() != 0) {
            String useverb = this.verbose ? "" : ". " + MLEMessages.format("USE_VERBOSE", new Object[0]);
            throw new Exception(MLEMessages.format("ROLLUP_FAILED", p.exitValue(), useverb));
        }
        return sb.toString();
    }

    private String getObjectReference() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.moduleName;
        }
        return this.moduleName;
    }

    private String getCompilationErrors(String schema, String object) {
        String qry;
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("name", object.toUpperCase());
        if (schema == null) {
            qry = "select TEXT from USER_ERRORS where NAME=:name and TYPE='MLE MODULE' order by SEQUENCE";
        } else {
            qry = "select TEXT from DBA_ERRORS where OWNER=:owner and NAME=:name and TYPE='MLE MODULE' order by SEQUENCE";
            binds.put("owner", schema.toUpperCase());
        }
        StringBuilder sb = new StringBuilder();
        try (PreparedStatement stm = this.getPreparedStatement(qry, binds);
             ResultSet rs = stm.executeQuery();){
            while (rs.next()) {
                sb.append(rs.getString(1)).append(System.lineSeparator());
            }
        }
        catch (Throwable ex) {
            sb.append(MLEMessages.get("NO_ERR_PRIV")).append(": ").append(ex.getMessage());
        }
        return sb.toString();
    }

    private void executeDDL(String cmd) throws Exception {
        this.verboseLog(cmd);
        try (Statement stm = this.conn.createStatement();){
            stm.executeUpdate(cmd);
        }
    }

    private PreparedStatement getPreparedStatement(String cmd, HashMap<String, String> binds) {
        this.verboseLog(cmd);
        this.verboseLogAttr("SQL statement placeholders", binds.toString());
        return this.dbUtil.prepareExecute(cmd, binds);
    }

    private void verboseLog(String key, String value) {
        if (this.verbose) {
            this.ctx.writeln(String.format("%s: %s", key, value));
        }
    }

    private void verboseLog(String msg) {
        if (this.verbose) {
            this.ctx.writeln(msg);
        }
    }

    private void verboseLogAttr(String key, String value) {
        if (this.verbose) {
            this.ctx.writeln(String.format("%s: %s", key, value));
        }
    }
}

