/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class LiquibaseStringUtils {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    public static String clobToString(Clob data) throws SQLException, IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        Reader reader = data.getCharacterStream();
        BufferedReader br = new BufferedReader(reader);
        while (-1 != (b = br.read())) {
            sb.append((char)b);
        }
        br.close();
        return sb.toString();
    }

    public static int nthOccurrence(String str, char c, int n) {
        int i = n;
        if (0 >= i) {
            return -1;
        }
        int pos = str.indexOf(c);
        while (1 < i && -1 != pos) {
            --i;
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }

    public static String replaceVal(String parm, String value, String doc) {
        String s = value;
        if (null == s) {
            s = "";
        }
        return doc.replace(parm, s);
    }

    public static List<String> splitString(String stringtoSplit, int length) {
        ArrayList<String> returnStringList = new ArrayList<String>((stringtoSplit.length() + length - 1) / length);
        for (int start = 0; start < stringtoSplit.length(); start += length) {
            returnStringList.add(stringtoSplit.substring(start, Math.min(stringtoSplit.length(), start + length)));
        }
        return returnStringList;
    }

    public static String trim(String s) {
        return LiquibaseStringUtils.rtrim(LiquibaseStringUtils.ltrim(s));
    }

    public static String rtrim(String s) {
        return RTRIM.matcher(s).replaceAll("");
    }

    public static String ltrim(String s) {
        return LTRIM.matcher(s).replaceAll("");
    }

    public static String trimEndofSql(String sql) {
        String s = sql;
        while (s.trim().endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

