/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import com.google.common.base.Throwables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import lombok.Generated;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.generator.changesets.data.ChangeData;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class LbFileUtils {
    private static final String ILLEGAL_CHARACTERS = "[/\\\\?%*:|\"<>.']";
    private static File log;
    private static FileHandler fileHandler;

    private LbFileUtils() {
    }

    public static String getSourceResourceParent(AbstractOracleStatement statement) throws LiquibaseException {
        if (statement.getSourceType().equalsIgnoreCase("FILE")) {
            return LbFileUtils.cleanPath(Paths.get(LbFileUtils.getSourceResource(statement), new String[0]).getParent().toString());
        }
        return LbFileUtils.cleanPath(Paths.get(LbFileUtils.getSourceResource(statement), new String[0]).toString());
    }

    public static String getSourceResource(AbstractOracleStatement statement) throws LiquibaseException {
        Path ret = Paths.get(LbFileUtils.getPath(statement), new String[0]);
        if (ret.getParent() == null && ret.toString().startsWith("/")) {
            return LbFileUtils.cleanPath(ret.getFileName().toString().substring(1));
        }
        return LbFileUtils.cleanPath(ret.toString());
    }

    private static void addFile(String file, ArrayList<String> recs) {
        if (!recs.contains(file)) {
            recs.add(file);
        }
    }

    public static String getPath(AbstractOracleStatement statement) throws LiquibaseException {
        ArrayList<String> tested = new ArrayList<String>();
        String cwd = LbUtils.getCWD();
        String sourceRef = LbFileUtils.getSourceRefString();
        String changeLog = LbFileUtils.getChangeLogString(statement);
        List<String> searchPaths = LbFileUtils.getSearchPathList();
        String file = LbFileUtils.getFileString(statement);
        for (String string : searchPaths) {
            Path spPath = Paths.get(string, new String[0]);
            Path candidate = spPath.isAbsolute() ? spPath.resolve(file).normalize() : (statement.isRelative() ? Paths.get(cwd, new String[0]).resolve(sourceRef).resolve(string).resolve(changeLog).resolve(file).normalize() : Paths.get(cwd, new String[0]).resolve(sourceRef).resolve(string).resolve(file).normalize());
            if (Files.exists(candidate, new LinkOption[0])) {
                return candidate.toString();
            }
            LbFileUtils.addFile(candidate.toString(), tested);
        }
        Path candidate = statement.isRelative() ? Paths.get(cwd, new String[0]).resolve(sourceRef).resolve(changeLog).resolve(file).normalize() : Paths.get(cwd, new String[0]).resolve(sourceRef).resolve(file).normalize();
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toString();
        }
        LbFileUtils.addFile(candidate.toString(), tested);
        candidate = Paths.get(cwd, new String[0]).resolve(file).normalize();
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toString();
        }
        LbFileUtils.addFile(candidate.toString(), tested);
        for (String sp : searchPaths) {
            Path spPath = Paths.get(sp, new String[0]);
            if (!spPath.isAbsolute()) continue;
            candidate = spPath.resolve(file).normalize();
            if (Files.exists(candidate, new LinkOption[0])) {
                return candidate.toString();
            }
            LbFileUtils.addFile(candidate.toString(), tested);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to locate file ").append(file).append("\n\tSearched Locations:");
        for (String loc : tested) {
            stringBuilder.append("\n\t").append(loc);
        }
        throw new LiquibaseException(stringBuilder.toString());
    }

    public static String cleanPath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        try {
            Path normalized = Paths.get(path, new String[0]).normalize();
            return normalized.toString();
        }
        catch (Exception e) {
            return path;
        }
    }

    public static String getFileString(boolean ovf, String fileName) throws IOException {
        return LbFileUtils.cleanPath(LbFileUtils.getFile(ovf, fileName, LbUtils.getContext()).toString());
    }

    public static File getFile(boolean ovf, String fileName, ScriptRunnerContext ctx) throws IOException {
        Path parent;
        Path fpath = Paths.get(fileName, new String[0]);
        Path cwdPath = Paths.get(LbUtils.getCWD(ctx), new String[0]);
        Path targetPath = !fpath.isAbsolute() ? cwdPath.resolve(fpath).normalize() : fpath.normalize();
        if (!ovf) {
            String stem = LbFileUtils.removeIllegalCharacters(com.google.common.io.Files.getNameWithoutExtension((String)targetPath.getFileName().toString()), true);
            String ext = com.google.common.io.Files.getFileExtension((String)targetPath.getFileName().toString());
            int i = 1;
            Path parent2 = targetPath.getParent() == null ? cwdPath : targetPath.getParent();
            Path candidate = targetPath;
            while (Files.exists(candidate, new LinkOption[0])) {
                String numberedName = ext.isEmpty() ? stem + "_" + i : stem + "_" + i + "." + ext;
                candidate = parent2.resolve(numberedName);
                ++i;
            }
            targetPath = candidate;
        }
        if ((parent = targetPath.getParent()) != null && !Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        if (Files.notExists(targetPath, new LinkOption[0])) {
            Files.createFile(targetPath, new FileAttribute[0]);
        } else if (ovf) {
            Files.delete(targetPath);
            Files.createFile(targetPath, new FileAttribute[0]);
        } else {
            throw new IOException("Unable to create file " + String.valueOf(targetPath));
        }
        return targetPath.toFile();
    }

    public static String sanitizeFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        return fileName.replaceAll(ILLEGAL_CHARACTERS, "_");
    }

    public static String removeIllegalCharacters(String name, boolean singleSpaces) {
        String safe = name.trim();
        if ((safe = LbFileUtils.sanitizeFileName(safe)).endsWith("_")) {
            safe = safe.substring(0, safe.length() - 1);
        }
        safe = safe.replaceAll("\\s+", "_");
        if (singleSpaces) {
            safe = safe.replaceAll("_{2,}", "_");
        }
        return safe;
    }

    public static Path getPath(boolean ovf, String fileName) throws IOException {
        return Paths.get(LbFileUtils.getFile(ovf, fileName, LbUtils.getContext()).toString(), new String[0]);
    }

    public static void setCwd(String path, ScriptRunnerContext ctx) {
        Path newPath;
        String osName = "os.name";
        String windoz = "Windows";
        String cdPath = path.trim();
        if ((cdPath.startsWith("'") && cdPath.endsWith("'") || cdPath.startsWith("\"") && cdPath.endsWith("\"")) && 2 < cdPath.length()) {
            cdPath = cdPath.substring(1, cdPath.length() - 1);
        }
        if (System.getProperty(osName).startsWith(windoz) && cdPath.startsWith("/") && 3 < cdPath.length() && ":".equals(cdPath.substring(2, 3))) {
            cdPath = cdPath.substring(1);
        }
        if (System.getProperty(osName).startsWith(windoz)) {
            cdPath = cdPath.replace("/", "\\");
        }
        if (!System.getProperty(osName).startsWith(windoz) && cdPath.startsWith("~")) {
            cdPath = cdPath.replaceFirst("~", System.getProperty("user.home"));
        }
        Path currentDir = Paths.get((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]);
        ctx.putProperty("script.runner.previous_dir", (Object)currentDir);
        try {
            newPath = currentDir.resolve(cdPath);
        }
        catch (Exception e) {
            ctx.write(MessageFormat.format(oracle.dbtools.raptor.scriptrunner.commands.Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
            return;
        }
        try {
            newPath = newPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException ignored) {
            return;
        }
        File f = newPath.toFile();
        if (f.isDirectory()) {
            String cPath;
            try {
                cPath = f.getCanonicalPath();
            }
            catch (IOException ignored) {
                return;
            }
            ctx.putProperty("script.runner.cd_command", (Object)cPath);
            ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), cPath);
        } else {
            ctx.write(MessageFormat.format(oracle.dbtools.raptor.scriptrunner.commands.Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
        }
    }

    public static String writeErrorLog(String data) throws IOException {
        File file = LbFileUtils.getLogFile(true);
        if (!file.exists()) {
            throw new IOException("Unable to create log file.");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(data);
            String string = Paths.get(file.toString(), new String[0]).getFileName().toString();
            return string;
        }
    }

    public static File getLogFile(boolean errorLog) throws IOException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        String logPath = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LOG_PATH);
        if (logPath == null || logPath.isEmpty()) {
            logPath = LbUtils.getCWD();
        } else if (!Paths.get(logPath, new String[0]).toFile().isAbsolute()) {
            logPath = Paths.get(LbUtils.getCWD(), logPath).toString();
        }
        if (errorLog) {
            File log = Paths.get(logPath, "sqlcl-lb-error" + timestamp.getTime() + ".log").toFile();
            boolean newFile = log.createNewFile();
            if (newFile) {
                return log;
            }
            throw new IOException(Messages.getString("UNABLE_CREATE_LOGFILE"));
        }
        File log = Paths.get(logPath, "sqlcl-lb-" + timestamp.getTime() + ".log").toFile();
        boolean newFile = log.createNewFile();
        if (newFile) {
            LbFileUtils.log = log;
            return log;
        }
        throw new IOException(Messages.getString("UNABLE_CREATE_LOGFILE"));
    }

    public static String writeFile(String filename, String changelog) throws IOException {
        File file = LbFileUtils.getFile((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.OVERWRITE_FILES), filename, LbUtils.getContext());
        BufferedWriter writer = LbFileUtils.getWriter(file);
        if (writer == null) {
            throw new IOException("Unable to create and write to file " + String.valueOf(file));
        }
        writer.write(changelog);
        writer.close();
        return file.toString();
    }

    public static void writeFile(ChangeData data) throws IOException {
        File file = data.getFILE();
        BufferedWriter writer = LbFileUtils.getWriter(file);
        if (writer == null) {
            throw new IOException("Unable to create and write to file " + data.getFILENAME());
        }
        writer.write(data.getCHANGELOG());
        writer.close();
    }

    public static void writeSqlFile(ChangeData data, Connection conn) throws LiquibaseException, IOException, SQLException {
        String ddl;
        String oType = data.getOTYPE();
        String oName = data.getONAME();
        String sql = "COMMENT".equals(oType) ? data.getDDL().substring(data.getDDL().indexOf("COMMENT")) : ("SYNONYM".equals(oType) ? ((ddl = data.getDDL()) != null && ddl.contains("PUBLIC SYNONYM") ? ddl : DbmsMetaUtils.getDdlFromDb(conn, oType, oName)) : DbmsMetaUtils.getDdlFromDb(conn, oType, oName));
        if (sql == null) {
            throw new LiquibaseException("Unable to generate DDL for object type: " + oType + "  named: " + oName);
        }
        BufferedWriter sqlwriter = LbFileUtils.getWriter(data.getSQLFILE());
        if (sqlwriter == null) {
            throw new LiquibaseException("Unable to generate DDL for object type: " + oType + "  named: " + oName);
        }
        sql = LbUtils.replaceUserSchema(sql, conn.getSchema(), data);
        sqlwriter.write(sql);
        sqlwriter.close();
    }

    public static BufferedWriter getWriter(File file) {
        try {
            Path path = Paths.get(file.toString(), new String[0]);
            return new BufferedWriter(new FileWriter(path.toString()));
        }
        catch (Exception e) {
            LbUtils.report("unable to get file path for :" + file.toString());
            oracle.dbtools.util.Logger.warn(LbFileUtils.class, (Throwable)e);
            return null;
        }
    }

    public static void configureLogging(Level level, File logFile) throws IOException {
        log = logFile;
        JavaLogService logService = (JavaLogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        logService.setParent(liquibaseLogger);
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        Logger rootLogger = Logger.getLogger("");
        Level cliLogLevel = level;
        if (null != log) {
            if (null == fileHandler) {
                fileHandler = new FileHandler(log.toString(), true);
                fileHandler.setFormatter(new SimpleFormatter());
                rootLogger.addHandler(fileHandler);
            }
            fileHandler.setLevel(level);
            cliLogLevel = Level.OFF;
        }
        ArrayList<String> channels = new ArrayList<String>(Arrays.asList("", "liquibase"));
        for (String channel : channels) {
            String s = channel;
            if ("all".equalsIgnoreCase(s)) {
                s = "";
            }
            Logger.getLogger(s).setLevel(level);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(cliLogLevel);
        }
    }

    public static void cleanup() {
        if (null != fileHandler) {
            fileHandler.flush();
            fileHandler.close();
        }
        if (LbUtils.getCommand() != null) {
            LbUtils.getCommand().close();
            LbUtils.setCommand(null);
            fileHandler = null;
            LbUtils.resetErrors();
        }
    }

    public static String writeApexInstallFile(String fileName, String data) throws IOException, LiquibaseException {
        File file;
        BufferedWriter writer;
        String tempfile = null;
        if (null != LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR) && !LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR).toString().isEmpty()) {
            Path path = Paths.get((String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR), fileName);
            tempfile = path.normalize().toString();
        }
        ChangeData chData = new ChangeData(LbUtils.getCommand());
        if (null == tempfile || tempfile.isEmpty()) {
            tempfile = fileName;
        }
        if (null == (writer = LbFileUtils.getWriter(file = LbFileUtils.getFile(chData.isOVERWRITEFILES(), tempfile, LbUtils.getContext())))) {
            throw new LiquibaseException("Unable to write Apex install file.");
        }
        writer.write(data);
        writer.close();
        return Paths.get(file.toString(), new String[0]).getFileName().toString();
    }

    private static String getChangeLogString(AbstractOracleStatement statement) {
        String cwd = LbUtils.getCWD();
        String clogString = statement.getFile();
        if (clogString == null || clogString.isEmpty()) {
            return "";
        }
        Path cwdPath = Paths.get(cwd, new String[0]).normalize();
        Path clogPath = Paths.get(clogString, new String[0]).normalize();
        Path clogParent = clogPath.getParent();
        if (clogParent == null) {
            return "";
        }
        if (clogParent.startsWith(cwdPath)) {
            Path rel = cwdPath.relativize(clogParent);
            return rel.toString();
        }
        return clogParent.toString();
    }

    public static String getSourceRefString() throws LiquibaseException {
        Path sourcePath;
        String cwd = LbUtils.getCWD();
        String sourceString = LbUtils.getContext().getSourceRef();
        if (sourceString == null || sourceString.isEmpty()) {
            return "";
        }
        if (sourceString.startsWith("file:")) {
            try {
                sourcePath = Paths.get(new URI(sourceString)).normalize();
            }
            catch (URISyntaxException e) {
                throw new LiquibaseException(Throwables.getStackTraceAsString((Throwable)e));
            }
        } else {
            sourcePath = Paths.get(sourceString, new String[0]).normalize();
        }
        Path cwdPath = Paths.get(cwd, new String[0]).normalize();
        Path sourceParent = sourcePath.getParent();
        if (sourceParent == null) {
            return "";
        }
        if (sourceParent.startsWith(cwdPath)) {
            Path rel = cwdPath.relativize(sourceParent);
            return rel.toString();
        }
        return sourceParent.toString();
    }

    private static String getFileString(AbstractOracleStatement statement) {
        if (statement.getSourceType().equalsIgnoreCase("FILE")) {
            return statement.getSource();
        }
        return "";
    }

    private static List<String> getSearchPathList() {
        List sps = (List)LbUtils.getCommand().getParsedCommand().getOptionValue((Id)LBOptions.Options.SEARCH_PATH);
        if (sps != null) {
            return sps;
        }
        return new ArrayList<String>();
    }

    @Generated
    public static File getLog() {
        return log;
    }

    @Generated
    public static void setLog(File log) {
        LbFileUtils.log = log;
    }
}

