/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.util.Logger;
import oracle.jdbc.OraclePreparedStatement;

public class DbmsMetaUtils {
    public static final String FROM_DUAL = "') from dual";
    public static final String SEPERATOR = "##################################################################################";
    public static final String START_WITH_0_9_START_WITH = "<START_WITH>/d*</START_WITH>";
    public static final String START_WITH_1_START_WITH = "<START_WITH>1</START_WITH>";

    public static String getAlterDdl(Connection conn, String source, String dest, String type) throws SQLException {
        return DbmsMetaUtils.getAlterDdl(conn, source, dest, type, LbUtils.getCommand().isFlagSet(LBOptions.Options.DEBUG));
    }

    public static String getAlterDdlWithTransform(Connection conn, String source, String dest, String type, String oname, boolean cons, boolean consasalter, boolean refcons, boolean storage, boolean segs, boolean tblspc, boolean emit, String schema, String coll) throws SQLException {
        String s = source;
        String d = dest;
        ResultSet rs = null;
        String query = QueryUtils.getXMLQueries().getQuery("alterDdlwithTransforms", conn).getSql();
        if ("TABLE".equalsIgnoreCase(type) || "SEQUENCE".equalsIgnoreCase(type)) {
            if (dest != null && !dest.isEmpty()) {
                d = dest.replaceAll(START_WITH_0_9_START_WITH, START_WITH_1_START_WITH);
            }
            if (source != null && !source.isEmpty()) {
                s = source.replaceAll(START_WITH_0_9_START_WITH, START_WITH_1_START_WITH);
            }
        }
        try {
            String string;
            block13: {
                OraclePreparedStatement pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
                try {
                    pstatement.setStringForClob(1, s);
                    pstatement.setStringForClob(2, d);
                    pstatement.setString(3, type.toUpperCase());
                    pstatement.setString(4, oname.toUpperCase());
                    pstatement.setInt(5, cons ? 0 : 1);
                    pstatement.setInt(6, consasalter ? 0 : 1);
                    pstatement.setInt(7, refcons ? 0 : 1);
                    pstatement.setInt(8, storage ? 0 : 1);
                    pstatement.setInt(9, segs ? 0 : 1);
                    pstatement.setInt(10, tblspc ? 0 : 1);
                    pstatement.setInt(11, emit ? 0 : 1);
                    pstatement.setString(12, schema.toUpperCase());
                    pstatement.setString(13, coll.toUpperCase());
                    rs = pstatement.executeQuery();
                    string = DbmsMetaUtils.getStringFromRs(rs);
                    if (pstatement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (pstatement != null) {
                        try {
                            pstatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstatement.close();
            }
            return string;
        }
        finally {
            if (null != rs && !rs.isClosed()) {
                rs.close();
            }
        }
    }

    private static String getStringFromRs(ResultSet rs) throws SQLException {
        Clob holder = null;
        while (null != rs && rs.next()) {
            holder = rs.getClob(1);
        }
        String ddl = null == holder || 0L == holder.length() ? null : holder.getSubString(1L, (int)holder.length());
        return ddl;
    }

    public static String getAlterDdl(Connection conn, String source, String dest, String type, boolean debug) throws SQLException {
        String s = source;
        String d = dest;
        String query = QueryUtils.getXMLQueries().getQuery("alterDdl", conn).getSql();
        Clob v_return = null;
        ResultSet rs = null;
        if ("TABLE".equalsIgnoreCase(type) || "SEQUENCE".equalsIgnoreCase(type)) {
            if (source != null && !source.isEmpty()) {
                s = source.replaceAll(START_WITH_0_9_START_WITH, START_WITH_1_START_WITH);
            }
            if (dest != null && !dest.isEmpty()) {
                d = dest.replaceAll(START_WITH_0_9_START_WITH, START_WITH_1_START_WITH);
            }
        }
        try {
            String string;
            block25: {
                OraclePreparedStatement pstatement;
                block23: {
                    String string2;
                    block24: {
                        pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
                        if (debug) {
                            Logger.info(DbmsMetaUtils.class, (String)SEPERATOR);
                            Logger.info(DbmsMetaUtils.class, (String)"doc 1 - source");
                            Logger.info(DbmsMetaUtils.class, (String)s);
                            Logger.info(DbmsMetaUtils.class, (String)SEPERATOR);
                            Logger.info(DbmsMetaUtils.class, (String)"doc 2 - dest");
                            Logger.info(DbmsMetaUtils.class, (String)d);
                            Logger.info(DbmsMetaUtils.class, (String)SEPERATOR);
                        }
                        pstatement.setStringForClob(1, s);
                        pstatement.setStringForClob(2, d);
                        pstatement.setString(3, type);
                        try {
                            rs = pstatement.executeQuery();
                        }
                        catch (SQLException e) {
                            String string3 = null;
                            if (pstatement != null) {
                                pstatement.close();
                            }
                            if (null != rs && !rs.isClosed()) {
                                rs.close();
                            }
                            return string3;
                        }
                        try {
                            while (null != rs && rs.next()) {
                                v_return = rs.getClob(1);
                            }
                            if (0L >= (null != v_return ? v_return.length() : 0L)) break block23;
                            string2 = v_return.getSubString(1L, (int)v_return.length());
                            if (pstatement == null) break block24;
                        }
                        catch (Throwable throwable) {
                            if (pstatement != null) {
                                try {
                                    pstatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pstatement.close();
                    }
                    return string2;
                }
                string = null;
                if (pstatement == null) break block25;
                pstatement.close();
            }
            return string;
        }
        finally {
            if (null != rs && !rs.isClosed()) {
                rs.close();
            }
        }
    }

    public static String getDdlFromXmlorSxml(Connection conn, String xml, String oType, String action) throws SQLException {
        String query;
        if (action.equalsIgnoreCase("sxml")) {
            query = QueryUtils.getXMLQueries().getQuery("sxmlToDdlConvertFunction", conn).getSql();
        } else if (action.equalsIgnoreCase("xml")) {
            query = QueryUtils.getXMLQueries().getQuery("xmlToDdlConvertFunction", conn).getSql();
        } else {
            return null;
        }
        ResultSet rs = null;
        HashMap<String, Object> parms = DbmsMetaUtils.getDDLParms(conn, LbUtils.getContext());
        try {
            String string;
            block16: {
                OraclePreparedStatement pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
                try {
                    pstatement.setStringForClob(1, xml.trim());
                    pstatement.setString(2, oType);
                    pstatement.setInt(3, "ON".equals(parms.get("CONSTRAINTS")) ? 0 : 1);
                    pstatement.setInt(4, "ON".equals(parms.get("REF_CONSTRAINTS")) ? 0 : 1);
                    pstatement.setInt(5, "ON".equals(parms.get("OID")) ? 0 : 1);
                    pstatement.setInt(6, "ON".equals(parms.get("STORAGE")) ? 0 : 1);
                    pstatement.setInt(7, "ON".equals(parms.get("SEGMENT_ATTRIBUTES")) ? 0 : 1);
                    pstatement.setInt(8, "ON".equals(parms.get("TABLESPACE")) ? 0 : 1);
                    pstatement.setInt(9, "ON".equals(parms.get("PARTITIONING")) ? 0 : 1);
                    String COLLATION = (String)parms.get("COLLATION_CLAUSE");
                    pstatement.setString(10, null == COLLATION ? "NEVER" : COLLATION);
                    pstatement.setString(11, conn.getSchema());
                    try {
                        rs = pstatement.executeQuery();
                    }
                    catch (SQLException e) {
                        Logger.warn(DbmsMetaUtils.class, (Throwable)e);
                        throw e;
                    }
                    string = DbmsMetaUtils.getStringFromRs(rs);
                    if (pstatement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (pstatement != null) {
                        try {
                            pstatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstatement.close();
            }
            return string;
        }
        finally {
            if (null != rs && !rs.isClosed()) {
                rs.close();
            }
        }
    }

    private static HashMap<String, Object> getDDLParms(Connection conn, ScriptRunnerContext ctx) {
        ScriptRunnerContext.Parameters instance = ctx.getParameterInstance();
        HashMap parms = instance.getParameters("ddl.parms");
        if (null == parms || parms.isEmpty()) {
            ctx.setCurrentConnection(conn);
            SetDDLSettings.resetDDLParameters((ScriptRunnerContext)ctx);
            parms = instance.getParameters("ddl.parms");
        }
        return parms;
    }

    public static String getSxmlFromDb(Connection conn, String otype, String oname) throws SQLException {
        if ("SCRIPT".equalsIgnoreCase(otype)) {
            return null;
        }
        return DbmsMetaUtils.executeSql("select dbms_metadata.get_sxml( '" + otype.toUpperCase() + "', '" + oname + FROM_DUAL, conn);
    }

    public static String executeSql(String sql, Connection conn) throws SQLException {
        ResultSet rs = null;
        try {
            String string;
            block14: {
                PreparedStatement pstatement;
                block12: {
                    String string2;
                    block13: {
                        pstatement = conn.prepareStatement(sql);
                        try {
                            rs = pstatement.executeQuery();
                            if (!rs.next()) break block12;
                            string2 = rs.getString(1);
                            if (pstatement == null) break block13;
                        }
                        catch (Throwable throwable) {
                            if (pstatement != null) {
                                try {
                                    pstatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pstatement.close();
                    }
                    return string2;
                }
                string = null;
                if (pstatement == null) break block14;
                pstatement.close();
            }
            return string;
        }
        finally {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
    }

    public static String getDdlFromDb(Connection conn, String otype, String oname) {
        try {
            String oType = otype.toUpperCase();
            if ("SCRIPT".equalsIgnoreCase(oType)) {
                return null;
            }
            DbmsMetaUtils.setDdlParms(conn);
            if ("COMMENT".equalsIgnoreCase(oType)) {
                return DbmsMetaUtils.executeSql("select dbms_metadata.get_dependent_ddl( 'COMMENT', '" + oname + FROM_DUAL, conn);
            }
            if ("JOB".equalsIgnoreCase(oType)) {
                return DbmsMetaUtils.executeSql("select dbms_metadata.get_ddl( 'PROCOBJ', '" + oname + FROM_DUAL, conn);
            }
            String sql = DbmsMetaUtils.executeSql("select dbms_metadata.get_ddl( '" + oType + "', '" + oname + FROM_DUAL, conn);
            if (sql != null && sql.contains("FLASHBACK ARCHIVE")) {
                sql = sql.replaceAll("(?im)^\\s*ALTER TABLE.*FLASHBACK ARCHIVE.*(?:\\r?\\n)?", "");
            }
            return sql;
        }
        catch (SQLException e) {
            Logger.warn(DbmsMetaUtils.class, (Throwable)e);
            return null;
        }
    }

    private static void setDdlParms(Connection conn) {
        try {
            HashMap<String, Object> parms = DbmsMetaUtils.getDDLParms(conn, LbUtils.getContext());
            for (Map.Entry<String, Object> entry : parms.entrySet()) {
                SetDDLSettings.setDDLParameter((Connection)conn, (String)entry.getKey(), (String)((String)entry.getValue()));
            }
            SetDDLSettings.setDDLParameter((Connection)conn, (String)"INSERT", (String)"OFF");
        }
        catch (Exception e) {
            Logger.warn(DbmsMetaUtils.class, (Throwable)e);
        }
    }

    public static String getTriggerStatus(Connection conn, String oname) throws SQLException {
        return DbmsMetaUtils.executeSql("select status from dba_triggers where trigger_name = '" + oname + "'", conn);
    }

    public static boolean isSxmlType(String name) {
        try {
            SXML_OBJECT_TYPES.valueOf(name.toUpperCase().trim());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static enum SXML_OBJECT_TYPES {
        AQ_QUEUE,
        AQ_QUEUE_TABLE,
        AQ_TRANSFORM,
        ASSOCIATION,
        AUDIT,
        AUDIT_OBJ,
        CLUSTER,
        CONTEXT,
        DEFAULT_ROLE,
        DATABASE_EXPORT,
        FGA_POLICY,
        DIMENSION,
        INDEX,
        LIBRARY,
        INDEXTYPE,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_LOG,
        OPERATOR,
        PROFILE,
        PROXY,
        REFRESH_GROUP,
        RESOURCE_COST,
        RLS_CONTEXT,
        RLS_GROUP,
        RLS_POLICY,
        RMGR_CONSUMER_GROUP,
        RMGR_INTITIAL_CONSUMER_GROUP,
        RMGR_PLAN,
        RMGR_PLAN_DIRECTIVE,
        ROLE,
        ROLLBACK_SEGMENT,
        SEQUENCE,
        TABLE,
        TABLESPACE,
        TRUSTED_DB_LINK,
        TYPE,
        USER,
        VIEW,
        XMLSCHEMA,
        XS_ACL,
        XS_ACL_PARAM,
        XS_DATA_SECURITY,
        XS_NAMESPACE,
        XS_ROLE,
        XS_ROLESET,
        XS_ROLE_GRANT,
        XS_SECURITY_CLASS,
        XS_USER;

    }
}

