/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.resourceaccessor;

import java.io.IOException;
import java.util.List;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.logging.Logger;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import oracle.dbtools.raptor.liquibase.resourceaccessor.SqlClCompositeResourceAccessor;

public class SqlClSearchPathResourceAccessor
extends SqlClCompositeResourceAccessor {
    public SqlClSearchPathResourceAccessor(ResourceAccessor ... defaultAccessors) {
        this((String)GlobalConfiguration.SEARCH_PATH.getCurrentValue(), defaultAccessors);
    }

    public List<ResourceAccessor> getAccessors() {
        return super.getResourceAccessors();
    }

    public SqlClSearchPathResourceAccessor(String searchPath, ResourceAccessor ... defaultAccessors) {
        super(new ResourceAccessor[0]);
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        if (searchPath == null) {
            for (ResourceAccessor accessor : defaultAccessors) {
                this.addResourceAccessor(accessor);
            }
        } else {
            PathHandlerFactory parserFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            StringUtil.splitAndTrim((String)searchPath, (String)",").forEach(path -> {
                try {
                    this.addResourceAccessor(parserFactory.getResourceAccessor(path));
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getUI().sendMessage(e.getMessage());
                    log.severe(e.getMessage(), (Throwable)e);
                }
            });
        }
        StringBuilder logMessage = new StringBuilder("Overall search path: " + System.lineSeparator());
        for (String location : this.describeLocations()) {
            logMessage.append("  - ").append(location).append(System.lineSeparator());
        }
        log.fine(logMessage.toString().trim());
    }

    public SqlClSearchPathResourceAccessor addResourceAccessor(String root) throws IOException {
        PathHandlerFactory parserFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        return (SqlClSearchPathResourceAccessor)super.addResourceAccessor(parserFactory.getResourceAccessor(root));
    }
}

