/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.RollbackOraclePlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.CreateProcedureStatement;

@DatabaseChange(name="createOracleProcedure", description="Create oracle procedure", priority=1)
public class CreateProcedureChange
extends AbstractCommonPlSqlChange {
    public CreateProcedureChange() {
        this.setObjectType("PROCEDURE");
    }

    public CreateProcedureChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("PROCEDURE");
    }

    protected Change[] createInverses() {
        RollbackOraclePlSqlChange inverse = new RollbackOraclePlSqlChange(this);
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Procedure {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateProcedureStatement stmt = new CreateProcedureStatement(this);
        return new SqlStatement[]{stmt};
    }
}

