/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.diff.output.changelog.orcl;

import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.View;
import oracle.dbtools.raptor.liquibase.ext.ora.change.CreateProcedureChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropProcedureChange;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclFunction;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclProcedure;

public class OrclProcedureChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator,
ChangedObjectChangeGenerator,
UnexpectedObjectChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (OrclProcedure.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{View.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{OrclFunction.class};
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        OrclProcedure proc = (OrclProcedure)missingObject;
        CreateProcedureChange change = new CreateProcedureChange();
        change.setObjectName(proc.getName());
        change.setObjectType("PROCEDURE");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(proc.getSource());
        return new Change[]{change};
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        OrclProcedure proc = (OrclProcedure)unexpectedObject;
        DropProcedureChange change = new DropProcedureChange();
        change.setObjectName(proc.getName());
        change.setObjectType("PROCEDURE");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(proc.getSource());
        return new Change[]{change};
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        OrclProcedure proc = (OrclProcedure)changedObject;
        CreateProcedureChange change = new CreateProcedureChange();
        change.setObjectName(proc.getName());
        change.setObjectType("PROCEDURE");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(proc.getSource());
        return new Change[]{change};
    }
}

