/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.diff.output.changelog.orcl;

import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.liquibase.ext.ora.change.CreateFunctionChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropFunctionChange;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclFunction;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclProcedure;

public class OrclFunctionChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator,
ChangedObjectChangeGenerator,
UnexpectedObjectChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (OrclFunction.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{OrclProcedure.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        OrclFunction func = (OrclFunction)missingObject;
        CreateFunctionChange change = new CreateFunctionChange();
        change.setObjectName(func.getName());
        change.setObjectType("FUNCTION");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(func.getSource());
        return new Change[]{change};
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        OrclFunction func = (OrclFunction)changedObject;
        CreateFunctionChange change = new CreateFunctionChange();
        change.setObjectName(func.getName());
        change.setObjectType("FUNCTION");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(func.getSource());
        return new Change[]{change};
    }

    public Change[] fixUnexpected(DatabaseObject unexpectedObject, DiffOutputControl control, Database referenceDatabase, Database comparisionDatabase, ChangeGeneratorChain chain) {
        OrclFunction func = (OrclFunction)unexpectedObject;
        DropFunctionChange change = new DropFunctionChange();
        change.setObjectName(func.getName());
        change.setObjectType("FUNCTION");
        change.setOwnerName(referenceDatabase.getDefaultSchemaName());
        change.setSource(func.getSource());
        return new Change[]{change};
    }
}

