/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.updateconfiguration;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.DatabaseUser;
import oracle.dbtools.extension.rcv.models.WalletEntry;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.rcvconf.Action;
import oracle.dbtools.extension.rcv.models.rcvconf.CurrentState;
import oracle.dbtools.extension.rcv.models.rcvconf.Phase;
import oracle.dbtools.extension.rcv.models.rcvconf.RcvConf;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.FileLocker;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.ShowRMANConfigWorkflow;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.OnboardDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.UpdateProtectedDatabaseStep;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public class UpdateWalletStep
implements Step {
    private WorkflowLogger logger;
    private String dbUniqueName;
    private FleetAgentContext fleetAgentContext;
    private char[] password;

    public UpdateWalletStep(String dbUniqueName, WorkflowLogger logger) {
        this.dbUniqueName = dbUniqueName;
        this.logger = logger;
        this.fleetAgentContext = FleetAgentContext.get(dbUniqueName);
    }

    public UpdateWalletStep password(char[] password) {
        this.password = password;
        return this;
    }

    @Override
    public Result run() {
        FileLocker fl = new FileLocker(String.join((CharSequence)File.separator, this.fleetAgentContext.getLocksDirectory(), "update_wallet.lock"), 10);
        Optional<Result> resultOptional = fl.execute(this::runStep);
        return resultOptional.orElseGet(() -> new Result(Status.FAILED, "Timed out waiting for lock."));
    }

    public Result runStep() {
        Map<String, String> rmanConfig;
        Optional<Connection> connOptional;
        String[] payload;
        Result result;
        RcvConf rcvConf = ConfigurationManager.getRcvConf(this.dbUniqueName);
        Optional<Action<String>> actionOptional = rcvConf.getActions().getWalletEntriesAction();
        if (actionOptional.isPresent()) {
            Action<String> action = actionOptional.get();
            String opType = action.getOperationType();
            String[] payload2 = action.getPayload();
            if (opType.equalsIgnoreCase("ADD")) {
                result = this.addWalletEntries(List.of(payload2));
                if (result.getStatus().equals((Object)Status.FAILED)) {
                    return result;
                }
            } else if (opType.equalsIgnoreCase("REMOVE")) {
                result = this.removeWalletEntries(List.of(payload2));
                if (result.getStatus().equals((Object)Status.FAILED)) {
                    return result;
                }
            } else {
                this.logger.log(Level.FINE, "Unexpected operation type " + opType);
            }
        } else {
            CurrentState currentState = rcvConf.getCurrentState();
            Optional<String[]> aliasesOptional = currentState.getTnsAliases();
            if (aliasesOptional.isPresent()) {
                String[] tnsAliases = aliasesOptional.get();
                result = this.addWalletEntries(List.of(tnsAliases));
                if (result.getStatus().equals((Object)Status.FAILED)) {
                    return result;
                }
            } else {
                this.logger.log(Level.FINE, "No need to update wallet.");
            }
        }
        if (rcvConf.getPhase().equals((Object)Phase.MIGRATE) && (actionOptional = rcvConf.getActions().getRmanCatalogConnectionAction()).isPresent() && (payload = actionOptional.get().getPayload()).length > 0 && (connOptional = NamedConnectionsManager.getConnection(FleetAgentContext.getConnectionName(this.dbUniqueName))).isPresent() && (rmanConfig = ShowRMANConfigWorkflow.getRMANConfig(this.dbUniqueName)).containsKey("credential_alias") && !rmanConfig.get("credential_alias").equals(payload[0])) {
            ConfigureRMANWorkflow wf = new ConfigureRMANWorkflow.Builder("credential_alias", payload[0]).build(connOptional.get());
            wf.setLogger(this.logger);
            return wf.run();
        }
        return new Result(Status.SUCCESS);
    }

    public Result addWalletEntries(List<String> aliases) {
        ProtectedDatabaseCache protectedDatabaseCache = this.fleetAgentContext.getProtectedDatabaseCache();
        String walletLocation = protectedDatabaseCache.getWalletLocation();
        ArrayList<String> missingAliases = new ArrayList<String>();
        String vpcUserName = protectedDatabaseCache.getVpcUserName();
        if (vpcUserName == null) {
            return Result.ucwGetVpcUserError();
        }
        OracleWallet wallet = WalletManager.createWallet(walletLocation);
        HashMap<String, WalletEntry> walletEntries = WalletManager.getWalletEntries(wallet);
        for (String alias : aliases) {
            boolean foundEntry = false;
            for (String id : walletEntries.keySet()) {
                String walletAlias = walletEntries.get(id).getCredentialAlias();
                String username = walletEntries.get(id).getUserName();
                if (!walletAlias.equalsIgnoreCase(alias) || !username.equals(vpcUserName)) continue;
                foundEntry = true;
                break;
            }
            if (foundEntry) continue;
            missingAliases.add(alias);
        }
        if (!missingAliases.isEmpty()) {
            char[] password = this.getVpcPassword(vpcUserName);
            if (password == null) {
                password = OnboardDatabaseStep.generateRandomPassword();
                UpdateProtectedDatabaseStep step = new UpdateProtectedDatabaseStep(protectedDatabaseCache.getEndpoint(), protectedDatabaseCache.getOcid(), this.logger);
                step.password(password);
                return step.run();
            }
            DatabaseUser vpcUser = new DatabaseUser(vpcUserName, password);
            for (String alias : missingAliases) {
                vpcUser.storePassword(wallet, alias);
            }
        }
        return new Result(Status.SUCCESS);
    }

    public Result removeWalletEntries(List<String> aliases) {
        ProtectedDatabaseCache protectedDatabaseCache = this.fleetAgentContext.getProtectedDatabaseCache();
        String walletLocation = protectedDatabaseCache.getWalletLocation();
        String vpcUserName = protectedDatabaseCache.getVpcUserName();
        if (vpcUserName == null) {
            return Result.ucwGetVpcUserError();
        }
        OracleWallet wallet = WalletManager.createWallet(walletLocation);
        for (String alias : aliases) {
            try {
                WalletManager.deleteCredential(wallet, alias);
            }
            catch (IOException | OracleSecretStoreException e) {
                String error = String.format("Failed to remove alias %s from wallet %s: %s", alias, walletLocation, e.getMessage());
                this.logger.getLogger().log(Level.FINE, error, e);
                return new Result(Status.FAILED, error);
            }
        }
        return new Result(Status.SUCCESS);
    }

    private char[] getVpcPassword(String vpcUserName) {
        String defaultWallet;
        char[] passwordCharArray = null;
        String walletLocation = this.fleetAgentContext.getProtectedDatabaseCache().getWalletLocation();
        OracleWallet wallet = WalletManager.createWallet(walletLocation);
        passwordCharArray = WalletManager.getSecretForUser(wallet, vpcUserName);
        if (passwordCharArray == null && !walletLocation.equals(defaultWallet = RCVCommandBase.getWalletDirectory(this.dbUniqueName))) {
            OracleWallet alternateWallet = WalletManager.createWallet(defaultWallet);
            passwordCharArray = WalletManager.getSecretForUser(alternateWallet, vpcUserName);
        }
        return passwordCharArray;
    }
}

