/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase;

import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.OnboardDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.UpdateProtectedDatabaseStep;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureProtectedDatabaseWorkflow
extends ProtectedDatabaseWorkflow {
    private boolean updatePassword;
    private String protectionPolicyId;
    private List<RecoveryServiceSubnetInput> recoverySubnets = new ArrayList<RecoveryServiceSubnetInput>();
    private Boolean realtimeRedo;
    private String compartmentId;
    private boolean scheduled;

    public ConfigureProtectedDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.CONFIGURE_DATABASE, conn, ctx);
        Result optionsCheck = this.checkOptions(command);
        if (!optionsCheck.getStatus().equals((Object)Status.SUCCESS)) {
            throw Result.wfResultToException(optionsCheck.getMessage());
        }
        this.protectionPolicyId = (String)command.getOptionValue((Id)RCVOptions.Options.PROTECTION_POLICY_ID);
        List subnets = (List)command.getOptionValue((Id)RCVOptions.Options.RECOVERY_SERVICE_SUBNETS);
        if (subnets != null) {
            for (String id : subnets) {
                this.recoverySubnets.add(RecoveryServiceSubnetInput.builder().recoveryServiceSubnetId(id).build());
            }
        }
        this.compartmentId = (String)command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.updatePassword = command.isFlagSet((Id)RCVOptions.Options.PASSWORD);
        this.scheduled = command.isFlagSet((Id)RCVOptions.Options.SCHEDULED);
    }

    @Override
    public String getLockFileName() {
        if (this.updatePassword) {
            return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.FETCH_CONFIG) + ".lock");
        }
        return null;
    }

    @Override
    public int getLockTimeout() {
        return this.updatePassword ? 10 : 0;
    }

    public Result checkOptions(ParsedCommand command) {
        Map options = command.getOptions();
        for (String option : options.keySet()) {
            if (options.get(option) == null) continue;
            return new Result(Status.SUCCESS);
        }
        return Result.missingOption(RcvMessages.format("WF_MISSING_PROVIDE_AT_LEAST_ONE", new Object[0]));
    }

    @Override
    public Result run(boolean verbose) {
        WorkflowLogger logger = this.getWorkflowLogger();
        if (verbose) {
            logger.log(Level.INFO, "Log file: " + logger.getLogFile());
        }
        Database database = this.getDatabase();
        ProtectedDatabaseCache cache = database.getFleetAgentContext().getProtectedDatabaseCache();
        String protectedDatabaseId = database.getOcid();
        UpdateProtectedDatabaseStep step = new UpdateProtectedDatabaseStep(cache.getEndpoint(), protectedDatabaseId, this.getWorkflowLogger());
        if (this.updatePassword) {
            char[] password = this.scheduled ? OnboardDatabaseStep.generateRandomPassword() : Utils.promptAndConfirmPassword("Enter a new password for VPC user:", "Confirm new password for VPC user:");
            step.password(password);
        }
        if (this.compartmentId != null) {
            step.compartmentId(this.compartmentId);
        }
        if (this.protectionPolicyId != null) {
            step.protectionPolicyId(this.protectionPolicyId);
        }
        if (!this.recoverySubnets.isEmpty()) {
            step.recoveryServiceSubnets(this.recoverySubnets);
        }
        if (this.realtimeRedo != null) {
            step.realtimeRedo(this.realtimeRedo);
        }
        return step.run();
    }

    @Override
    public void handleFailure() {
    }
}

