/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.utils.BackupManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.ShowRMANConfigWorkflow;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class ConfigureRMANStep
implements Step {
    private Connection conn;
    private WorkflowLogger logger;

    public ConfigureRMANStep(Connection conn, WorkflowLogger logger) {
        this.conn = conn;
        this.logger = logger;
    }

    @Override
    public Result run() {
        String currentValue;
        this.logger.log(Level.INFO, "Configuring RMAN");
        Database database = RCVCommandBase.getDatabase(this.conn);
        Map<String, String> currentConfig = ShowRMANConfigWorkflow.getRMANConfig(database.getDbUniqueName());
        ProtectedDatabaseCache metadataCache = database.getFleetAgentContext().getProtectedDatabaseCache();
        HashMap<String, String> fleetAgentManagedConfig = new HashMap<String, String>();
        HashMap<String, String> customerManagedConfig = new HashMap<String, String>();
        HashMap<String, String> newConfig = new HashMap<String, String>();
        String databaseVersion = DatabaseUtils.getDatabaseVersion(this.conn);
        String walletLocation = metadataCache.getWalletLocation();
        String credentialAlias = metadataCache.getCredentialAlias();
        String libraLocation = metadataCache.getLibraLocation();
        fleetAgentManagedConfig.put("wallet_location", walletLocation);
        fleetAgentManagedConfig.put("credential_alias", credentialAlias);
        fleetAgentManagedConfig.put("lib_ra_location", libraLocation);
        fleetAgentManagedConfig.put("db_version", databaseVersion);
        fleetAgentManagedConfig.put("node_count", String.valueOf(database.getDatabaseMetadataCache().getRemoteHostNames().size() + 1));
        fleetAgentManagedConfig.put("backup_level_one_database", "FALSE");
        fleetAgentManagedConfig.put("backup_level_zero_database", "FALSE");
        customerManagedConfig.put("client_max_channels", "16");
        customerManagedConfig.put("compression_algorithm", "LOW");
        customerManagedConfig.put("archive_log_backup_interval", String.valueOf(900));
        customerManagedConfig.put("preferred_backup_db_unique_name", database.getDbUniqueName());
        customerManagedConfig.put("preferred_backup_start_time", Utils.getTimeStampWithTimeZone());
        customerManagedConfig.put("encryption_algorithm", "AES256");
        try {
            String rmanVersion = BackupManager.getRMANVersion();
            if (rmanVersion != null && !rmanVersion.isEmpty()) {
                fleetAgentManagedConfig.put("rman_version", rmanVersion);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "Failed to get RMAN version.");
        }
        for (String configName : fleetAgentManagedConfig.keySet()) {
            String correctValue = (String)fleetAgentManagedConfig.get(configName);
            if (!currentConfig.containsKey(configName)) continue;
            currentValue = currentConfig.get(configName);
            if (configName.equals("backup_level_zero_database") || configName.equals("backup_level_one_database")) {
                if ("N".equals(currentValue)) continue;
                newConfig.put(configName, correctValue);
                continue;
            }
            if (correctValue == null || correctValue.equals(currentValue)) continue;
            newConfig.put(configName, correctValue);
        }
        for (String configName : customerManagedConfig.keySet()) {
            String defaultValue = (String)customerManagedConfig.get(configName);
            if (!currentConfig.containsKey(configName)) continue;
            currentValue = currentConfig.get(configName);
            if (currentValue == null) {
                newConfig.put(configName, defaultValue);
                continue;
            }
            if (!configName.equals("client_max_channels") && !configName.equals("archive_log_backup_interval") || !currentValue.equals("0")) continue;
            newConfig.put(configName, defaultValue);
        }
        if (newConfig.isEmpty()) {
            return new Result(Status.SKIPPED);
        }
        ConfigureRMANWorkflow configureRMANWorkflow = new ConfigureRMANWorkflow.Builder(newConfig).fetchLatestConfig(false).build(this.conn);
        configureRMANWorkflow.setLogger(this.logger);
        return configureRMANWorkflow.run(false);
    }
}

