/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowRMANConfigWorkflow
extends ProtectedDatabaseWorkflow {
    private Connection fleetEngineConn;
    private ParsedCommand command;
    private static Set<String> excludedParameters = Set.of("backup_level_one_database", "backup_level_zero_database");

    public ShowRMANConfigWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_RMAN, conn, ctx);
        this.command = command;
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new GetBackupConfigValues());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        Database database = this.getDatabase();
        this.fleetEngineConn = FleetEngine.getEngineConnection(database);
    }

    public static Map<String, String> getRMANConfig(String dbUniqueName) {
        HashMap<String, String> config = new HashMap<String, String>();
        String CONFIGURATION_NAME = "configuration_name";
        String CONFIGURATION_VALUE = "configuration_value";
        String GET_CONFIG_SQL = String.format("select %s, %s from ra_ce_site_config order by %s", "configuration_name", "configuration_value", "configuration_name");
        try (Connection fleetEngineConnection = FleetEngine.getEngineConnection(dbUniqueName);
             ResultSet rs = DBUtil.getInstance((Connection)fleetEngineConnection).executeOracleQuery(GET_CONFIG_SQL, null);){
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString("configuration_name");
                    String value = rs.getString("configuration_value");
                    config.put(name, value);
                }
            }
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_GET_BACKUP_CONFIG_VALUES_ERROR_MSG", new Object[0]), e);
        }
        return config;
    }

    public class GetBackupConfigValues
    implements Step {
        @Override
        public Result run() {
            String systemType = GlobalMetadata.load().getSystemType();
            WorkflowLogger logger = ShowRMANConfigWorkflow.this.getWorkflowLogger();
            Map<String, String> config = ShowRMANConfigWorkflow.getRMANConfig(ShowRMANConfigWorkflow.this.getDbUniqueName());
            for (String name : config.keySet()) {
                if (name.equalsIgnoreCase("ocpu_per_node") && systemType.equals("ON_PREMISES") || excludedParameters.contains(name.toLowerCase())) continue;
                String value = config.get(name);
                logger.log(Level.INFO, String.format("Config Name:  %s", name));
                logger.log(Level.INFO, String.format("Config Value: %s\n", value));
            }
            return new Result(Status.SUCCESS);
        }
    }
}

