/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.ProtectionPolicySummary;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowProtectionPolicyWorkflow
extends Workflow {
    private String compartmentId;
    private String protectionPolicyName;
    private String protectionPolicyId;
    private RecoveryClientManager recoveryClientManager;
    private ParsedCommand command;
    private Connection conn;

    public ShowProtectionPolicyWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_PROTECTION_POLICY, conn, ctx);
        this.command = command;
        this.conn = conn;
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new ShowProtectionPolicy());
        super.setSteps(steps);
    }

    @Override
    public void initState() {
        this.compartmentId = (String)this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.protectionPolicyName = (String)this.command.getOptionValue((Id)RCVOptions.Options.NAME);
        this.protectionPolicyId = (String)this.command.getOptionValue((Id)RCVOptions.Options.ID);
        String endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        if (this.protectionPolicyName != null && this.protectionPolicyId != null) {
            throw Result.invalidOptionException(RcvMessages.format("WF_INVALID_MUTUALLY_EXCLUSIVE3", RCVOptions.Options.NAME.getName().toLowerCase(), RCVOptions.Options.ID.getName().toLowerCase()));
        }
        if (this.compartmentId == null) {
            if (this.conn == null) {
                this.compartmentId = GlobalMetadata.load().getAuthentication().getTenancyId();
                if (this.compartmentId == null) {
                    throw Result.missingOptionException(RcvMessages.format("WF_MISSING_COMPARTMENT_ID_OPTION", RCVOptions.Options.COMPARTMENT_ID.getName().toLowerCase()));
                }
            } else {
                Database database = RCVCommandBase.getDatabase(this.conn);
                ProtectedDatabaseCache protectedDatabaseCache = database.getFleetAgentContext().getProtectedDatabaseCache();
                if (protectedDatabaseCache.getCompartmentId() == null) {
                    this.compartmentId = GlobalMetadata.load().getAuthentication().getTenancyId();
                    if (this.compartmentId == null) {
                        throw Result.missingOptionException(RcvMessages.format("WF_MISSING_COMPARTMENT_ID_OPTION", RCVOptions.Options.COMPARTMENT_ID.getName().toLowerCase()));
                    }
                } else {
                    this.compartmentId = protectedDatabaseCache.getCompartmentId();
                }
            }
        }
        if (endpoint == null && this.conn != null) {
            endpoint = RCVCommandBase.getDatabase(this.conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, this.getWorkflowLogger().getLogger());
    }

    private class ShowProtectionPolicy
    implements Step {
        private ShowProtectionPolicy() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = ShowProtectionPolicyWorkflow.this.getWorkflowLogger();
            List<Object> summaryList = new ArrayList();
            if (ShowProtectionPolicyWorkflow.this.protectionPolicyId == null) {
                summaryList = ShowProtectionPolicyWorkflow.this.protectionPolicyName == null ? ShowProtectionPolicyWorkflow.this.recoveryClientManager.getAllResourcesBySearchingAllCompartments(ShowProtectionPolicyWorkflow.this.compartmentId, compId -> ShowProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPolicies((String)compId)) : ShowProtectionPolicyWorkflow.this.recoveryClientManager.getAllResourcesBySearchingAllCompartments(ShowProtectionPolicyWorkflow.this.compartmentId, compId -> ShowProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPoliciesByName(ShowProtectionPolicyWorkflow.this.protectionPolicyName, (String)compId));
                if (summaryList != null && !summaryList.isEmpty()) {
                    summaryList = new ArrayList(summaryList.stream().collect(Collectors.toMap(ProtectionPolicySummary::getId, Function.identity(), (existing, replacement) -> existing)).values());
                }
            } else {
                ProtectionPolicy policy = ShowProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPolicy(ShowProtectionPolicyWorkflow.this.protectionPolicyId);
                if (policy == null) {
                    logger.log(Level.INFO, "No protection policy found.");
                } else {
                    logger.log(Level.INFO, "Display Name:            " + policy.getDisplayName());
                    logger.log(Level.INFO, "Lifecycle State:         " + String.valueOf(policy.getLifecycleState()));
                    if (policy.getCompartmentId() != null) {
                        logger.log(Level.INFO, "Compartment ID:          " + policy.getCompartmentId());
                    }
                    logger.log(Level.INFO, "OCID:                    " + policy.getId());
                    logger.log(Level.INFO, "Backup Retention Period: " + policy.getBackupRetentionPeriodInDays() + " days");
                    if (policy.getPolicyLockedDateTime() != null) {
                        logger.log(Level.INFO, "Policy locked:           " + policy.getPolicyLockedDateTime());
                    }
                }
                return new Result(Status.SUCCESS);
            }
            if (summaryList != null && !summaryList.isEmpty()) {
                for (ProtectionPolicySummary summary : summaryList) {
                    logger.log(Level.INFO, "Display Name:            " + summary.getDisplayName());
                    if (summary.getCompartmentId() != null) {
                        logger.log(Level.INFO, "Compartment ID:          " + summary.getCompartmentId());
                    }
                    logger.log(Level.INFO, "OCID:                    " + summary.getId());
                    logger.log(Level.INFO, "Backup Retention Period: " + summary.getBackupRetentionPeriodInDays() + " days");
                    if (summary.getPolicyLockedDateTime() != null) {
                        logger.log(Level.INFO, "Policy locked:           " + summary.getPolicyLockedDateTime());
                    }
                    logger.log(Level.INFO, "\n");
                }
            } else {
                logger.log(Level.INFO, "No protection policies found for compartment " + ShowProtectionPolicyWorkflow.this.compartmentId);
            }
            return new Result(Status.SUCCESS);
        }
    }
}

