/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJob;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJobs;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.scheduler.SchedulerFile;

public class RemoveScheduleWorkflow
extends ProtectedDatabaseWorkflow {
    private boolean localOnly;
    private String connectionName;
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();
    private List<FleetAgentJob> fleetAgentJobs = new ArrayList<FleetAgentJob>();
    private List<JobType> jobTypes;
    private Database database;

    public RemoveScheduleWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(conn, ctx, (List)command.getOptionValue((Id)RCVOptions.Options.JOB_TYPE), command.isFlagSet((Id)RCVOptions.Options.LOCAL));
    }

    public RemoveScheduleWorkflow(Connection conn, ScriptRunnerContext ctx, List<JobType> jobTypes, boolean localOnly) {
        super(RCVCommand.SubCommand.REMOVE_SCHEDULE, conn, ctx);
        this.localOnly = localOnly;
        this.jobTypes = jobTypes;
        this.database = this.getDatabase();
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new SaveConnection());
        steps.add(new RemoveJob());
        super.setSteps(steps);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.REMOVE_SCHEDULE) + ".lock");
    }

    @Override
    public void initState() {
        for (JobType type : this.jobTypes) {
            this.fleetAgentJobs.add(FleetAgentJobs.get(this.getDbUniqueName(), type));
        }
        this.connectionName = this.database.getFleetAgentContext().getConnectionName();
        if (!this.localOnly) {
            this.sshConnections = this.database.getDatabaseMetadataCache().getSshConnections(this.getWorkflowLogger().getLogger());
        }
    }

    private class SaveConnection
    implements Step {
        private SaveConnection() {
        }

        @Override
        public Result run() {
            if (RemoveScheduleWorkflow.this.sshConnections.isEmpty()) {
                return new Result(Status.SKIPPED);
            }
            ScriptRunnerContext ctx = RemoveScheduleWorkflow.this.getContext();
            Connection conn = RemoveScheduleWorkflow.this.getConnection();
            NamedConnectionsManager.saveConnection(conn, ctx, RemoveScheduleWorkflow.this.connectionName);
            if (!RemoveScheduleWorkflow.this.localOnly) {
                NamedConnectionsManager.propagateNamedConnectionToRemoteNodes(RemoveScheduleWorkflow.this.connectionName, RemoveScheduleWorkflow.this.sshConnections);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class RemoveJob
    implements Step {
        private RemoveJob() {
        }

        @Override
        public Result run() {
            SchedulerFile schedulerFile;
            WorkflowLogger logger = RemoveScheduleWorkflow.this.getWorkflowLogger();
            try {
                schedulerFile = new SchedulerFile();
            }
            catch (Exception e) {
                RemoveScheduleWorkflow.this.logException(e);
                return Result.schedulerFileError(RcvMessages.format("SCHEDULER_FILE_INIT_ERROR_MSG", new Object[0]));
            }
            for (FleetAgentJob fleetAgentJob : RemoveScheduleWorkflow.this.fleetAgentJobs) {
                String jobName = fleetAgentJob.getJobName();
                logger.log(Level.FINE, "Removing job " + jobName);
                try {
                    schedulerFile.removeJob(jobName);
                }
                catch (IOException e) {
                    RemoveScheduleWorkflow.this.logException(e);
                    return Result.schedulerFileError(RcvMessages.format("SCHEDULER_FILE_REMOVE_JOB_ERROR_MSG", jobName));
                }
            }
            if (!RemoveScheduleWorkflow.this.localOnly) {
                RCVCommand rcvCommand = new RCVCommand(RCVCommand.SubCommand.REMOVE_SCHEDULE).addOption(RCVOptions.Options.JOB_TYPE, RemoveScheduleWorkflow.this.jobTypes.stream().map(Enum::toString).collect(Collectors.joining(","))).addFlag(RCVOptions.Options.LOCAL);
                for (SshHelper sshConnection : RemoveScheduleWorkflow.this.sshConnections) {
                    String remoteHost = sshConnection.getHost();
                    logger.log(Level.FINE, "removing backup task on remote host " + remoteHost);
                    SystemCommand.ExecutionResult scheduleBackupResult = sshConnection.executeRcvCommand(RemoveScheduleWorkflow.this.connectionName, rcvCommand, RemoveScheduleWorkflow.this.database.getFleetAgentContext().getScriptsDirectory() + File.separator + "disable_backup.sql");
                    int rc = scheduleBackupResult.getReturnCode();
                    String scheduleBackupResultOutput = scheduleBackupResult.getOutput();
                    logger.log(Level.FINE, scheduleBackupResultOutput);
                    if (rc != 0 || scheduleBackupResultOutput.toLowerCase().contains("fail")) {
                        return Result.wfRemoteCommandError(RcvMessages.format("SBJ_FAILED_DISABLE_BACKUP_ERROR_MSG", remoteHost));
                    }
                    logger.log(Level.FINE, "Successfully disable backup on remote host " + remoteHost);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

