/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.requests.DeleteProtectionPolicyRequest;
import com.oracle.bmc.recovery.responses.DeleteProtectionPolicyResponse;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVObjects;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class RemoveProtectionPolicyWorkflow
extends Workflow {
    private WorkflowLogger logger = this.getWorkflowLogger();
    private String ocid;
    private RecoveryClientManager recoveryClientManager;

    public RemoveProtectionPolicyWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.REMOVE_PROTECTION_POLICY, conn, ctx);
        this.ocid = (String)command.getOptionValue((Id)RCVOptions.Options.ID);
        String endpoint = (String)command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        if (endpoint == null && conn != null) {
            endpoint = RCVCommandBase.getDatabase(conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, this.logger.getLogger());
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new RemoveProtectionPolicy());
        this.setSteps(steps);
    }

    public Result deleteProtectionPolicy() {
        DeleteProtectionPolicyRequest request = DeleteProtectionPolicyRequest.builder().protectionPolicyId(this.ocid).build();
        this.logger.log(Level.FINE, request.toString());
        DeleteProtectionPolicyResponse response = this.recoveryClientManager.deleteProtectionPolicyRequest(request);
        this.logger.log(Level.FINE, response.toString());
        this.logger.info("Waiting for protection policy to be deleted");
        LifecycleState state = this.recoveryClientManager.waitForResourceUpdate(600, 20, () -> this.recoveryClientManager.getProtectionPolicy(this.ocid).getLifecycleState());
        if (state.equals((Object)LifecycleState.Deleting)) {
            return Result.removeResourceTimeout(RCVObjects.PROTECTION_POLICY, this.ocid);
        }
        if (!state.equals((Object)LifecycleState.Deleted)) {
            return Result.verifyLifecycleStatusError("protection policy", state.getValue(), LifecycleState.Deleting.getValue(), LifecycleState.Deleted.getValue());
        }
        return new Result(Status.SUCCESS);
    }

    private class RemoveProtectionPolicy
    implements Step {
        private RemoveProtectionPolicy() {
        }

        @Override
        public Result run() {
            ProtectionPolicy protectionPolicy = RemoveProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPolicy(RemoveProtectionPolicyWorkflow.this.ocid);
            if (protectionPolicy.getIsPredefinedPolicy().booleanValue()) {
                String error = String.format("Cannot remove the specified protection policy (%s) because it is a default policy.", protectionPolicy.getDisplayName());
                return new Result(Status.FAILED, error);
            }
            LifecycleState state = protectionPolicy.getLifecycleState();
            switch (state) {
                case Deleting: 
                case DeleteScheduled: {
                    return new Result(Status.SKIPPED, "Protection policy is already being deleted.");
                }
                case Deleted: {
                    return new Result(Status.SKIPPED, "Protection policy has already been deleted.");
                }
                case Active: 
                case Failed: {
                    return RemoveProtectionPolicyWorkflow.this.deleteProtectionPolicy();
                }
            }
            return new Result(Status.FAILED, "Cannot remove the protection policy because it is '" + String.valueOf(state) + "'. Please try again later.");
        }
    }
}

