/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.LogArchiveConfig;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.UpdateProtectedDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateLogArchiveDestinationsStep;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class DisableRealtimeRedoWorkflow
extends ProtectedDatabaseWorkflow {
    private LogArchiveConfig currentLogArchiveConfig;
    private LogArchiveConfig dbrsLogArchiveConfig;
    private HashMap<Integer, LogArchiveDestination> currentDestinations;
    private boolean restartDatabase = false;
    private ProtectedDatabase protectedDatabase;
    private RecoveryClientManager recoveryClientManager;
    private boolean localOnly;
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();

    public DisableRealtimeRedoWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command.isFlagSet((Id)RCVOptions.Options.LOCAL), conn, ctx);
    }

    public DisableRealtimeRedoWorkflow(boolean localOnly, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.REMOVE_REALTIME_REDO, conn, ctx);
        this.localOnly = localOnly;
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new RunChecks());
        steps.add(new RemoveLogArchiveDestinations());
        steps.add(new RemoveRedoTransportUser());
        if (!localOnly) {
            steps.add(new DisableRealtimeRedoOnRemoteNodes());
            steps.add(new NotifyControlPlane());
            steps.add(new RestartDatabase());
        }
        super.setSteps(steps);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.ADD_REALTIME_REDO) + ".lock");
    }

    @Override
    public void initState() {
        Connection conn = this.getConnection();
        Database database = this.getDatabase();
        WorkflowLogger logger = this.getWorkflowLogger();
        this.sshConnections = database.getDatabaseMetadataCache().getSshConnections(logger.getLogger());
        String dbUniqueName = this.getDbUniqueName();
        String endpoint = database.getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        this.recoveryClientManager = new RecoveryClientManager(endpoint, logger.getLogger());
        this.dbrsLogArchiveConfig = new LogArchiveConfig(List.of(ConfigurationManager.getLogArchiveConfig(dbUniqueName)));
        String dgConfigString = DatabaseUtils.getLogArchiveConfig(conn);
        this.currentLogArchiveConfig = new LogArchiveConfig();
        if (dgConfigString != null) {
            this.currentLogArchiveConfig = new LogArchiveConfig(dgConfigString);
        }
        this.protectedDatabase = this.recoveryClientManager.getProtectedDatabase(database.getOcid());
    }

    private class RunChecks
    implements Step {
        private RunChecks() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = DisableRealtimeRedoWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Running prechecks");
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            if (DatabaseUtils.isMultitenant(conn) && DatabaseUtils.isPDB(conn)) {
                return Result.pdCheckPdbError();
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class RemoveLogArchiveDestinations
    implements Step {
        private RemoveLogArchiveDestinations() {
        }

        @Override
        public Result run() {
            Result result;
            WorkflowLogger logger = DisableRealtimeRedoWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Removing log archive destinations");
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            String dbUniqueName = DisableRealtimeRedoWorkflow.this.getDbUniqueName();
            UpdateLogArchiveDestinationsStep step = new UpdateLogArchiveDestinationsStep(conn, logger);
            Optional<LogArchiveConfig> LACOptional = step.createNewLogArchiveConfigByRemoving(ConfigurationManager.getLogArchiveConfig(dbUniqueName));
            if (LACOptional.isPresent()) {
                result = step.updateLogArchiveConfig(LACOptional.get());
                if (result.getStatus().equals((Object)Status.FAILED)) {
                    return result;
                }
                if (result.getStatus().equals((Object)Status.SUCCESS)) {
                    DisableRealtimeRedoWorkflow.this.restartDatabase = true;
                }
            }
            if ((result = step.removeLogArchiveDestinations(ConfigurationManager.getLogArchiveDestinationGroups(dbUniqueName))).getStatus().equals((Object)Status.SUCCESS)) {
                DisableRealtimeRedoWorkflow.this.restartDatabase = true;
            }
            return result;
        }
    }

    private class RemoveRedoTransportUser
    implements Step {
        private RemoveRedoTransportUser() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = DisableRealtimeRedoWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Removing redo transport user");
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            String currentRedoTransportUser = DatabaseUtils.getRedoTransportUser(conn);
            if (currentRedoTransportUser != null && currentRedoTransportUser.equals(DisableRealtimeRedoWorkflow.this.protectedDatabase.getVpcUserName())) {
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                parameterMap.put("redo_transport_user", "");
                DisableRealtimeRedoWorkflow.this.restartDatabase = true;
                try {
                    DatabaseUtils.updateParameter(conn, parameterMap);
                }
                catch (SQLException e) {
                    DisableRealtimeRedoWorkflow.this.logException(e);
                    return Result.databaseSqlError(RcvMessages.format("DRR_REDO_USER_UPDATE_ERROR_MSG", new Object[0]));
                }
            } else {
                return new Result(Status.SKIPPED);
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class DisableRealtimeRedoOnRemoteNodes
    implements Step {
        private DisableRealtimeRedoOnRemoteNodes() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = DisableRealtimeRedoWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Disabling real-time redo on remote nodes");
            Connection conn = DisableRealtimeRedoWorkflow.this.getConnection();
            ScriptRunnerContext ctx = DisableRealtimeRedoWorkflow.this.getContext();
            Database database = DisableRealtimeRedoWorkflow.this.getDatabase();
            FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
            if (DisableRealtimeRedoWorkflow.this.sshConnections.isEmpty()) {
                return new Result(Status.SKIPPED);
            }
            String connectionName = fleetAgentContext.getConnectionName();
            NamedConnectionsManager.saveConnection(conn, ctx, connectionName);
            if (!DisableRealtimeRedoWorkflow.this.localOnly) {
                NamedConnectionsManager.propagateNamedConnectionToRemoteNodes(connectionName, DisableRealtimeRedoWorkflow.this.sshConnections);
                RCVCommand rcvCommand = new RCVCommand(RCVCommand.SubCommand.REMOVE_REALTIME_REDO).addFlag(RCVOptions.Options.LOCAL);
                for (SshHelper sshConnection : DisableRealtimeRedoWorkflow.this.sshConnections) {
                    String remoteHost = sshConnection.getHost();
                    SystemCommand.ExecutionResult remoteResult = sshConnection.executeRcvCommand(connectionName, rcvCommand, fleetAgentContext.getScriptsDirectory() + File.separator + "disable_realtime_redo.sql", DatabaseUtils.getInstanceNameForHost(conn, remoteHost));
                    String output = remoteResult.getOutput();
                    if (output != null) {
                        logger.log(Level.FINE, output);
                    }
                    if (remoteResult.getReturnCode() == 0) continue;
                    return Result.wfRemoteCommandError(RcvMessages.format("DRR_FAILED_REMOVE_REMOTE_ERROR_MSG", remoteHost));
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class NotifyControlPlane
    implements Step {
        private NotifyControlPlane() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = DisableRealtimeRedoWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Notifying control plane");
            if (DisableRealtimeRedoWorkflow.this.protectedDatabase.getIsRedoLogsShipped().booleanValue()) {
                ProtectedDatabaseCache cache = DisableRealtimeRedoWorkflow.this.getDatabase().getFleetAgentContext().getProtectedDatabaseCache();
                UpdateProtectedDatabaseStep updateProtectedDatabaseStep = new UpdateProtectedDatabaseStep(cache.getEndpoint(), DisableRealtimeRedoWorkflow.this.getProtectedDatabaseOcid(), logger).realtimeRedo(false);
                return updateProtectedDatabaseStep.run();
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RestartDatabase
    implements Step {
        private RestartDatabase() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = DisableRealtimeRedoWorkflow.this.getWorkflowLogger();
            logger.log(Level.INFO, "Checking database");
            if (DisableRealtimeRedoWorkflow.this.restartDatabase) {
                logger.log(Level.INFO, "!! Action Required: Please restart the database to finish disabling real-time redo !!");
            }
            return new Result(Status.SUCCESS);
        }
    }
}

