/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.ConfigureRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.models.commandengine.InitRequest;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureRMANWorkflow
extends ProtectedDatabaseWorkflow {
    private final String TIME_FORMAT = "HH:mm:ss";
    private Map<String, String> parameters = new HashMap<String, String>();
    private int instanceId;
    private Connection fleetEngineConnection;
    private ParsedCommand command;
    private boolean invokedFromCli = true;
    private boolean fetchLatestConfig = true;
    private static Set<String> nonConfigurableParameters = Set.of("credential_alias", "db_version", "backup_level_one_database", "backup_level_zero_database", "node_count", "ocpu_per_node", "rman_version", "wallet_location");
    private static Set<String> configurableParameters = Set.of("archive_log_backup_interval", "client_max_channels", "compression_algorithm", "encryption_algorithm", "preferred_backup_db_unique_name", "preferred_backup_start_time");

    public ConfigureRMANWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command, conn, true);
    }

    public ConfigureRMANWorkflow(ParsedCommand command, Connection conn, boolean fetchLatestConfig) {
        super(RCVCommand.SubCommand.CONFIGURE_RMAN, conn, null);
        this.command = command;
        this.invokedFromCli = true;
        this.fetchLatestConfig = fetchLatestConfig;
        this.parameters.put((String)command.getOptionValue((Id)RCVOptions.Options.CONFIG_NAME), (String)command.getOptionValue((Id)RCVOptions.Options.CONFIG_VALUE));
    }

    private ConfigureRMANWorkflow(Builder builder, Connection conn) {
        super(RCVCommand.SubCommand.CONFIGURE_RMAN, conn, null);
        if (builder.parameters != null) {
            this.parameters = builder.parameters;
        }
        this.fetchLatestConfig = builder.fetchLatestConfig;
        this.invokedFromCli = false;
    }

    @Override
    public void initState() {
        if (this.invokedFromCli) {
            for (String name : this.parameters.keySet()) {
                String libRaLocation;
                if (nonConfigurableParameters.contains(name.toLowerCase())) {
                    throw Result.invalidOptionException(RcvMessages.format("WF_NON_CONFIGURABLE_PARAMETER", name, String.join((CharSequence)", ", configurableParameters)));
                }
                if (name.equalsIgnoreCase("preferred_backup_start_time")) {
                    String time = this.parameters.get(name);
                    if (this.isValidTimeFormat(time)) {
                        this.parameters.put(name, this.convertTimeToZonedTime(time));
                        continue;
                    }
                    throw Result.invalidOptionException(RcvMessages.format("WF_INVALID_PARAMETER_VALUE_1", name, "HH:mm:ss"));
                }
                if (!name.equalsIgnoreCase("lib_ra_location") || Files.exists(Paths.get(libRaLocation = this.parameters.get(name), new String[0]), new LinkOption[0])) continue;
                String error = RcvMessages.format("WF_NONEXISTENT_FILE", libRaLocation);
                throw Result.invalidOptionException(RcvMessages.format(error, name, "HH:mm:ss"));
            }
        }
        Database database = this.getDatabase();
        this.instanceId = DatabaseUtils.getNodeId(this.getConnection());
        this.fleetEngineConnection = FleetEngine.getEngineConnection(database);
        ArrayList<Step> steps = new ArrayList<Step>();
        if (this.fetchLatestConfig) {
            WorkflowLogger logger = this.getWorkflowLogger();
            UpdateZRCVConfigurationWorkflow wf = new UpdateZRCVConfigurationWorkflow(this.getConnection(), this.getContext());
            wf.setLogger(logger);
            steps.add(() -> wf.run(false));
        }
        steps.add(new ConfigureBackup());
        super.setSteps(steps);
    }

    private Result updateParameter(String configName, String configValue) {
        FleetEngineResponse.Status status;
        FleetEngineResponse response;
        WorkflowLogger logger = this.getWorkflowLogger();
        String dbUniqueName = this.getDbUniqueName();
        try {
            InitRequest initRequest = new InitRequest.Builder(this.fleetEngineConnection, dbUniqueName.toUpperCase(), this.instanceId, logger.getLogger()).build();
            response = FleetEngine.retry(2, initRequest);
            status = response.getStatus();
            if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                return Result.fengServerResponseError(response.getMessage());
            }
            if (response.getData() == null) {
                return Result.fengServerResponseError(RcvMessages.format("FENG_SERVER_INITIATE_ERROR_MSG", new Object[0]));
            }
        }
        catch (SQLException e) {
            this.logException(e);
            return Result.fengDatabaseSqlError(RcvMessages.format("FENG_INIT_CONNECTION_ERROR_MSG", new Object[0]));
        }
        int agentId = (Integer)response.getData();
        try {
            ConfigureRequest configureRequest = new ConfigureRequest.Builder(this.fleetEngineConnection, dbUniqueName, agentId, configName, configValue, logger.getLogger()).build();
            FleetEngineResponse<Void> configureResponse = configureRequest.execute();
            status = configureResponse.getStatus();
            if (!status.equals((Object)FleetEngineResponse.Status.SUCCESS)) {
                String responseMessage = configureResponse.getMessage();
                return Result.fengServerResponseError(RcvMessages.format("FENG_SERVER_CONFIGURE_ERROR_MSG", configName, status.toString(), responseMessage == null ? "" : responseMessage));
            }
            logger.log(Level.FINE, "Successfully updated config");
        }
        catch (SQLException e) {
            this.logException(e);
            return Result.fengDatabaseSqlError(RcvMessages.format("FENG_CONFIGURE_ERROR_MSG", new Object[0]));
        }
        return new Result(Status.SUCCESS);
    }

    private boolean isValidTimeFormat(String timestamp) {
        if (timestamp == null || timestamp.trim().isEmpty()) {
            return false;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        try {
            LocalTime.parse(timestamp, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private String convertTimeToZonedTime(String timestamp) {
        if (!this.isValidTimeFormat(timestamp)) {
            return null;
        }
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        LocalTime localTime = LocalTime.parse(timestamp, inputFormatter);
        LocalDate arbitraryDate = LocalDate.of(2025, 1, 1);
        LocalDateTime localDateTime = localTime.atDate(arbitraryDate);
        ZoneId zone = ZoneId.systemDefault();
        ZonedDateTime zonedDateTime = localDateTime.atZone(zone);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("HH:mm:ss VV");
        return zonedDateTime.format(outputFormatter);
    }

    public static class Builder {
        private Map<String, String> parameters;
        private boolean fetchLatestConfig;

        public Builder(String name, String value) {
            this.parameters = new HashMap<String, String>();
            this.parameters.put(name, value);
        }

        public Builder(Map<String, String> parameters) {
            this.parameters = parameters;
        }

        public Builder fetchLatestConfig(boolean fetchLatestConfig) {
            this.fetchLatestConfig = fetchLatestConfig;
            return this;
        }

        public ConfigureRMANWorkflow build(Connection conn) {
            return new ConfigureRMANWorkflow(this, conn);
        }
    }

    private class ConfigureBackup
    implements Step {
        private ConfigureBackup() {
        }

        @Override
        public Result run() {
            for (String name : ConfigureRMANWorkflow.this.parameters.keySet()) {
                Result result;
                if (ConfigureRMANWorkflow.this.parameters.get(name) == null || !(result = ConfigureRMANWorkflow.this.updateParameter(name, ConfigureRMANWorkflow.this.parameters.get(name))).getStatus().equals((Object)Status.FAILED)) continue;
                return result;
            }
            return new Result(Status.SUCCESS);
        }
    }
}

