/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.utils.LogManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureLogWorkflow
extends Workflow {
    private Map<String, Level> logLevels = Map.of("INFO", Level.FINE, "TRACE", Level.FINEST);
    private ParsedCommand command;

    public ConfigureLogWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.CONFIGURE_LOG, conn, ctx);
        this.command = command;
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new SetLoggingLevel());
        super.setSteps(steps);
    }

    private class SetLoggingLevel
    implements Step {
        private SetLoggingLevel() {
        }

        @Override
        public Result run() {
            WorkflowLogger logger = ConfigureLogWorkflow.this.getWorkflowLogger();
            String level = (String)ConfigureLogWorkflow.this.command.getOptionValue((Id)RCVOptions.Options.LOG_LEVEL);
            if (level != null) {
                logger.getLogger().log(Level.FINE, "Level: {0}", level);
                level = level.toUpperCase();
                if (ConfigureLogWorkflow.this.logLevels.containsKey(level)) {
                    LogManager.setLogLevel(ConfigureLogWorkflow.this.logLevels.get(level));
                    logger.log(Level.INFO, "Set log level to: " + level);
                } else {
                    logger.log(Level.SEVERE, "Incorrect log level: " + level);
                    return new Result(Status.FAILED);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

