/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;

public class TnsnamesHelper {
    public static TNSNames getTnsNames(String file) throws IOException {
        TNSNames tnsNames = null;
        FileInputStream primaryTnsReader = new FileInputStream(file);
        tnsNames = TNSNames.read((InputStream)primaryTnsReader);
        return tnsNames;
    }

    public static String getDefaultTnsAdmin(String dbUniqueName) {
        String tnsAdminProperty = System.getProperty("oracle.net.tns_admin");
        if (tnsAdminProperty != null && !tnsAdminProperty.isEmpty()) {
            return tnsAdminProperty;
        }
        String tnsAdminEnvVar = System.getenv("TNS_ADMIN");
        if (tnsAdminEnvVar != null && !tnsAdminEnvVar.isEmpty()) {
            return tnsAdminEnvVar;
        }
        return String.join((CharSequence)File.separator, DatabaseConfig.getOracleHome(dbUniqueName), "network", "admin");
    }

    public static String getDefaultTnsnamesFile(String dbUniqueName) {
        String tnsAdmin = TnsnamesHelper.getDefaultTnsAdmin(dbUniqueName);
        return String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora");
    }

    public static void writeTnsNames(String outputFile, TNSNames tnsNames) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             OutputStreamWriter output = new OutputStreamWriter(fileOutputStream);){
            for (String name : tnsNames.nsNames()) {
                output.write(name + " = " + tnsNames.getTNSEntry(name).getConnectionDescriptor() + "\n");
            }
        }
    }

    public static void writeTnsNames(String outputFile, Map<String, TNSEntry> tnsEntriesMap) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             OutputStreamWriter output = new OutputStreamWriter(fileOutputStream);){
            for (String name : tnsEntriesMap.keySet()) {
                output.write(name + " = " + tnsEntriesMap.get(name).getConnectionDescriptor() + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to update tnsnames " + outputFile, e);
        }
    }
}

