/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import com.oracle.bmc.recovery.model.FetchProtectedDatabaseConfigurationDetails;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.rcvconf.Action;
import oracle.dbtools.extension.rcv.models.rcvconf.CurrentState;
import oracle.dbtools.extension.rcv.models.rcvconf.LogArchiveDestinationGroupAction;
import oracle.dbtools.extension.rcv.models.rcvconf.RcvConf;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.security.pki.OracleWallet;

public class ConfigurationManager {
    public static final String RCV_CONF = "rcv.conf.txt";
    public static final String DBRS_NAMES = "dbrsnames.ora.txt";
    public static final String CERT_PEM = "certChainPem.txt";
    private static ConcurrentHashMap<String, RcvConf> rcvConfMap = new ConcurrentHashMap();

    public static RcvConf getRcvConf(String dbUniqueName) {
        RcvConf rcvConf;
        FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
        ProtectedDatabaseCache protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        String rcvConfTxt = fleetAgentContext.getRcvConfFile();
        String currentMd5Sum = null;
        if (!Files.exists(Path.of(rcvConfTxt, new String[0]), new LinkOption[0])) {
            ConfigurationManager.downloadAndUnzipConfigBundle(protectedDatabaseCache.getEndpoint(), protectedDatabaseCache.getOcid(), fleetAgentContext.getTnsAdmin());
        }
        File f = new File(rcvConfTxt);
        if (rcvConfMap.containsKey(dbUniqueName)) {
            String cachedMd5Sum;
            rcvConf = rcvConfMap.get(dbUniqueName);
            if (rcvConf.getLastModified() == f.lastModified()) {
                return rcvConf;
            }
            try {
                currentMd5Sum = Utils.getMD5Sum(rcvConfTxt);
            }
            catch (IOException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
            if (currentMd5Sum != null && (cachedMd5Sum = rcvConfMap.get(dbUniqueName).getMd5sum()) != null && cachedMd5Sum.equals(currentMd5Sum)) {
                return rcvConf;
            }
        }
        try {
            rcvConf = RcvConf.load(rcvConfTxt, dbUniqueName);
            rcvConfMap.put(dbUniqueName, rcvConf);
            return rcvConf;
        }
        catch (IOException e) {
            RCVCommandBase.getLogger().getLogger().log(Level.FINE, e.getMessage(), e);
            throw new RuntimeException("Failed to parse RCV conf " + rcvConfTxt + ": " + e.getMessage());
        }
    }

    public static String getCatalogAlias(String dbUniqueName) {
        RcvConf rcvConf = ConfigurationManager.getRcvConf(dbUniqueName);
        Optional<Action<String>> actionOptional = rcvConf.getActions().getRmanCatalogConnectionAction();
        if (actionOptional.isPresent()) {
            String[] payload = actionOptional.get().getPayload();
            if (payload.length > 0) {
                return payload[0];
            }
        } else {
            Optional<String> aliasOptional = rcvConf.getCurrentState().getRmanCatalogConnection();
            if (aliasOptional.isPresent()) {
                return aliasOptional.get();
            }
        }
        return ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, "DBRS");
    }

    public static void downloadAndUnzipConfigBundle(String endpoint, String protectedDatabaseId, String downloadDirectory) {
        RecoveryClientManager recoveryClientManager = new RecoveryClientManager(endpoint, null);
        try {
            String downloadPath = downloadDirectory + File.separatorChar + "config.zip";
            recoveryClientManager.getConfiguration(protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.All, downloadPath);
            Utils.unzipFile(downloadPath, downloadDirectory);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getMessage().contains("Unknown resource CaBundle")) {
                String rcvConfPath = downloadDirectory + File.separator + RCV_CONF;
                recoveryClientManager.getConfiguration(protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.Rcvconf, rcvConfPath);
                recoveryClientManager.getConfiguration(protectedDatabaseId, FetchProtectedDatabaseConfigurationDetails.ConfigurationType.Tnsnames, downloadDirectory + File.separator + DBRS_NAMES);
            }
            throw e;
        }
    }

    public static boolean isTnsnamesOraEquals(Map<String, TNSEntry> entries1, Map<String, TNSEntry> entries2) {
        String value;
        for (String alias : entries1.keySet()) {
            value = entries1.get(alias).getConnectionDescriptor();
            if (entries2.containsKey(alias)) {
                if (entries2.get(alias).getConnectionDescriptor().equals(value)) continue;
                return false;
            }
            return false;
        }
        for (String alias : entries2.keySet()) {
            value = entries2.get(alias).getConnectionDescriptor();
            if (entries1.containsKey(alias)) {
                if (entries1.get(alias).getConnectionDescriptor().equals(value)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean updateTnsnamesOra(Database database) throws IOException {
        FleetAgentContext fleetAgentContext = database.getFleetAgentContext();
        ProtectedDatabaseCache cache = fleetAgentContext.getProtectedDatabaseCache();
        String tnsAdmin = fleetAgentContext.getTnsAdmin();
        String tnsnamesOraPath = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora");
        String dbrsnamesOraPath = String.join((CharSequence)File.separator, tnsAdmin, DBRS_NAMES);
        File dbrsNamesFile = new File(dbrsnamesOraPath);
        if (!dbrsNamesFile.exists()) {
            ConfigurationManager.downloadAndUnzipConfigBundle(cache.getEndpoint(), database.getOcid(), tnsAdmin);
        }
        TNSNames dbrsNames = TnsnamesHelper.getTnsNames(dbrsnamesOraPath);
        HashMap<String, TNSEntry> newTnsNamesEntries = new HashMap<String, TNSEntry>();
        boolean overwriteTnsnames = false;
        boolean isADE = System.getenv("ADE_VIEW_ROOT") != null;
        for (String alias : dbrsNames.nsNames()) {
            TNSEntry entry = dbrsNames.getTNSEntry(alias);
            String newAlias = ConfigurationManager.updateAliasWithDbUniqueName(database.getDbUniqueName(), alias);
            if (isADE) {
                String regex = "(fqdn1|fqdn2)\\.us\\.oracle\\.com";
                TNSEntry newEntry = TNSEntry.builder((String)entry.getConnectionDescriptor().replaceAll(regex, "127.0.0.1")).build();
                newTnsNamesEntries.put(newAlias.toUpperCase(), newEntry);
                continue;
            }
            newTnsNamesEntries.put(newAlias.toUpperCase(), dbrsNames.getTNSEntry(alias));
        }
        if (Files.exists(Paths.get(tnsnamesOraPath, new String[0]), new LinkOption[0])) {
            TNSNames currentTnsnames = TnsnamesHelper.getTnsNames(tnsnamesOraPath);
            HashMap<String, TNSEntry> currentTnsNamesEntries = new HashMap<String, TNSEntry>();
            for (String alias : currentTnsnames.nsNames()) {
                currentTnsNamesEntries.put(alias.toUpperCase(), currentTnsnames.getTNSEntry(alias));
            }
            overwriteTnsnames = !ConfigurationManager.isTnsnamesOraEquals(currentTnsNamesEntries, newTnsNamesEntries);
        } else {
            overwriteTnsnames = true;
        }
        if (overwriteTnsnames) {
            try {
                Utils.copyFileContent(tnsnamesOraPath, tnsnamesOraPath + ".prev");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TnsnamesHelper.writeTnsNames(tnsnamesOraPath, newTnsNamesEntries);
        }
        return overwriteTnsnames;
    }

    public static void importRecoveryServiceCertificate(String dbUniqueName) {
        ProtectedDatabaseCache protectedDatabaseCache = RCVCommandBase.getProtectedDatabaseCache(dbUniqueName);
        String walletLocation = protectedDatabaseCache.getWalletLocation();
        Path certPath = ConfigurationManager.getCertificatePath(dbUniqueName);
        if (Files.exists(certPath, new LinkOption[0])) {
            OracleWallet wallet = WalletManager.createWallet(walletLocation);
            WalletManager.addCertificate(wallet, certPath);
        }
    }

    public static String getProtocolFromTnsnames(String tnsnamesPath) throws IOException {
        TNSNames tnsNames = TnsnamesHelper.getTnsNames(tnsnamesPath);
        Collection tnsEntries = tnsNames.tnsEntries();
        for (TNSEntry entry : tnsEntries) {
            String value = entry.getConnectionDescriptor();
            String regex = "(?i)\\(protocol=([^\\)]+)\\)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(value);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    public static Path getCertificatePath(String dbUniqueName) {
        return Paths.get(FleetAgentContext.get(dbUniqueName).getTnsAdmin() + File.separator + CERT_PEM, new String[0]);
    }

    public static void restoreLastConfiguration(String tnsAdmin) throws IOException {
        String goodTnsNames = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora.good");
        String tnsNames = String.join((CharSequence)File.separator, tnsAdmin, "tnsnames.ora");
        Files.move(Paths.get(goodTnsNames, new String[0]), Paths.get(tnsNames, new String[0]), new CopyOption[0]);
    }

    public static List<String> getWalletEntriesFromRcvConf(String dbUniqueName) {
        RcvConf rcvConf = ConfigurationManager.getRcvConf(dbUniqueName);
        Optional<Action<String>> actionOptional = rcvConf.getActions().getWalletEntriesAction();
        if (actionOptional.isPresent()) {
            Action<String> action = actionOptional.get();
            String opType = action.getOperationType();
            String[] payload = action.getPayload();
            if (opType.equalsIgnoreCase("ADD")) {
                return List.of(payload);
            }
        } else {
            CurrentState currentState = rcvConf.getCurrentState();
            Optional<String[]> aliasesOptional = currentState.getTnsAliases();
            if (aliasesOptional.isPresent()) {
                String[] tnsAliases = aliasesOptional.get();
                return List.of(tnsAliases);
            }
        }
        return List.of(ConfigurationManager.updateAliasWithDbUniqueName(dbUniqueName, "DBRS"));
    }

    public static Optional<String> getVpcUserNameFromRcvConf(String dbUniqueName) {
        RcvConf rcvConf = ConfigurationManager.getRcvConf(dbUniqueName);
        return rcvConf.getCurrentState().getVpcUser();
    }

    public static String[] getLogArchiveConfig(String dbUniqueName) {
        RcvConf rcvConf = ConfigurationManager.getRcvConf(dbUniqueName);
        Optional<Action<String>> actionOptional = rcvConf.getActions().getLogArchiveConfigAction();
        if (actionOptional.isPresent()) {
            Action<String> action = actionOptional.get();
            if (action.getOperationType().equalsIgnoreCase("ADD")) {
                return action.getPayload();
            }
        } else {
            Optional<String[]> configOptional = rcvConf.getCurrentState().getLogArchiveConfig();
            if (configOptional.isPresent()) {
                return configOptional.get();
            }
        }
        return new String[0];
    }

    public static LogArchiveDestination[] getLogArchiveDestinationGroups(String dbUniqueName) {
        RcvConf rcvConf = ConfigurationManager.getRcvConf(dbUniqueName);
        LogArchiveDestination[] destinations = new LogArchiveDestination[]{};
        Optional<LogArchiveDestinationGroupAction> actionOptional = rcvConf.getActions().getLogArchiveDestinationGroupsAction();
        if (actionOptional.isPresent()) {
            LogArchiveDestinationGroupAction action = actionOptional.get();
            if (action.getOperationType().equalsIgnoreCase("ADD")) {
                destinations = (LogArchiveDestination[])action.getPayload();
            }
        } else {
            Optional<LogArchiveDestination[]> destinationsOptional = rcvConf.getCurrentState().getLogArchiveDestinationGroups();
            if (destinationsOptional.isPresent()) {
                destinations = destinationsOptional.get();
            }
        }
        return destinations;
    }

    public static String updateAliasWithDbUniqueName(String dbUniqueName, String alias) {
        String newAlias = dbUniqueName + "_" + alias;
        return newAlias.substring(0, Math.min(newAlias.length(), 30));
    }
}

