/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.oci;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.http.HttpResponse;
import oracle.dbtools.extension.rcv.workflows.Result;

public class InstanceMetadata {
    private String jsonString;
    ObjectMapper objectMapper = new ObjectMapper();
    private JsonNode rootNode;

    public InstanceMetadata(HttpResponse<String> response) {
        this.jsonString = response.body();
        try {
            this.rootNode = this.objectMapper.readTree(this.jsonString);
        }
        catch (JsonProcessingException e) {
            throw Result.ociRequestParseException((Exception)((Object)e));
        }
    }

    public int getOcpu() {
        if (this.rootNode.has("shapeConfig") && this.rootNode.path("shapeConfig").has("ocpus")) {
            return this.rootNode.path("shapeConfig").get("ocpus").asInt();
        }
        return -1;
    }

    public String getId() {
        if (this.rootNode.has("id")) {
            return this.rootNode.get("id").asText();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.rootNode.has("displayName")) {
            return this.rootNode.get("displayName").asText();
        }
        return null;
    }

    public String getTenantId() {
        if (this.rootNode.has("tenantId")) {
            return this.rootNode.get("tenantId").asText();
        }
        return null;
    }
}

