/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.systemcommands;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;

public class RMANCommand
extends SystemCommand {
    private ConnectString target;
    private ConnectString catalog;
    private RMANScript rmanScript;
    private String catalogScript;
    private Map<String, String> args;
    private Logger logger;
    private String logFile;
    private String traceFile;
    private boolean append;
    private boolean checkSyntax;
    private boolean debug;
    private String tnsAdmin;
    private String rmanPath;
    private String oracleSid;
    private String oracleHome;

    private RMANCommand(Builder builder) {
        this(builder, RCVCommandBase.getOracleHome());
    }

    private RMANCommand(Builder builder, String oracleHome) {
        this.target = builder.target;
        this.catalog = builder.catalog;
        this.rmanScript = builder.rmanScript;
        this.catalogScript = builder.catalogScript;
        this.args = builder.args;
        this.logger = builder.logger;
        this.logFile = builder.logFile;
        this.traceFile = builder.traceFile;
        this.debug = builder.debug;
        this.append = builder.append;
        this.checkSyntax = builder.checkSyntax;
        this.tnsAdmin = builder.tnsAdmin;
        this.oracleSid = builder.oracleSid;
        this.oracleHome = oracleHome;
        this.rmanPath = Paths.get(oracleHome, "bin", "rman").toString();
        HashMap<String, String> env = new HashMap<String, String>();
        if (this.tnsAdmin != null) {
            env.put("TNS_ADMIN", this.tnsAdmin);
        }
        if (this.oracleSid != null) {
            env.put("ORACLE_SID", this.oracleSid);
        }
        env.put("ORACLE_HOME", oracleHome);
        env.put("NLS_DATE_FORMAT", "YYYY-MM-DD HH24:MI:SS");
        super.environment(env).logger(this.logger);
    }

    public List<String> generateCommand() {
        ArrayList<String> rmanArgs = new ArrayList<String>();
        rmanArgs.add(this.rmanPath);
        if (this.target != null) {
            rmanArgs.add("target");
            Object connectString = this.target.toString();
            if (!((String)connectString).equals("/")) {
                char firstChar = ((String)connectString).charAt(0);
                char lastChar = ((String)connectString).charAt(((String)connectString).length() - 1);
                if (!(firstChar == '\"' && lastChar == '\"' || firstChar == '\'' && lastChar == '\'')) {
                    connectString = "\"" + (String)connectString + "\"";
                }
            }
            rmanArgs.add((String)connectString);
        }
        if (this.catalog != null) {
            rmanArgs.add("catalog");
            rmanArgs.add(this.catalog.toString());
        }
        if (this.rmanScript != null) {
            rmanArgs.add("cmdfile='" + this.rmanScript.getScriptPath() + "'");
        } else if (this.catalogScript != null) {
            rmanArgs.add("script");
            rmanArgs.add(this.catalogScript);
        }
        if (this.logFile != null && !this.logFile.isEmpty()) {
            rmanArgs.add("log");
            rmanArgs.add(String.format("'%s'", this.logFile));
        }
        if (this.traceFile != null && !this.traceFile.isEmpty()) {
            rmanArgs.add("trace");
            rmanArgs.add(String.format("'%s'", this.traceFile));
        }
        if ((this.logFile != null && !this.logFile.isEmpty() || this.traceFile != null && !this.traceFile.isEmpty()) && this.append) {
            rmanArgs.add("append");
        }
        if (this.args != null && !this.args.keySet().isEmpty()) {
            rmanArgs.add("using");
            for (int i = 1; i <= this.args.keySet().size(); ++i) {
                if (!this.args.containsKey("" + i)) continue;
                rmanArgs.add("'" + this.args.get("" + i) + "'");
            }
        }
        return rmanArgs;
    }

    public SystemCommand.ExecutionResult executeWithRetryAsSys() {
        SystemCommand.ExecutionResult result = this.execute();
        if (result.getReturnCode() != 0 && this.target != null && this.target.getPrivilege().equals("sysbackup")) {
            ConnectString newTarget = new ConnectString.Builder().build();
            RMANCommand newCommand = new Builder(newTarget, this.catalog, this.rmanScript).args(this.args).append(this.append).checkSyntax(this.checkSyntax).debug(this.debug).logFile(this.logFile).logger(this.logger).traceFile(this.traceFile).tnsAdmin(this.tnsAdmin).oracleSid(this.oracleSid).build();
            result = newCommand.execute();
        }
        return result;
    }

    public SystemCommand.ExecutionResult execute() {
        Pattern pattern;
        Matcher matcher;
        List<String> rmanArgs = this.generateCommand();
        SystemCommand.ExecutionResult result = super.run(rmanArgs);
        if (result.getReturnCode() == 0 && (matcher = (pattern = Pattern.compile("RMAN-\\d{5}")).matcher(result.getOutput())).find()) {
            return new SystemCommand.ExecutionResult(result.getOutput(), 21);
        }
        return result;
    }

    public static class Builder {
        private ConnectString target;
        private ConnectString catalog;
        private RMANScript rmanScript;
        private String catalogScript;
        private Map<String, String> args;
        private String logFile;
        private String traceFile;
        private boolean append;
        private boolean debug;
        private boolean checkSyntax;
        private String tnsAdmin;
        private Logger logger;
        private String oracleSid;
        private String oracleHome;

        public Builder(ConnectString target, ConnectString catalog, RMANScript rmanScript) {
            this.target = target;
            this.catalog = catalog;
            this.rmanScript = rmanScript;
        }

        public Builder(ConnectString target, ConnectString catalog, String catalogScript) {
            this.target = target;
            this.catalog = catalog;
            this.catalogScript = catalogScript;
        }

        public Builder args(Map<String, String> args) {
            this.args = args;
            return this;
        }

        public Builder append(boolean append) {
            this.append = append;
            return this;
        }

        public Builder checkSyntax(boolean checkSyntax) {
            this.checkSyntax = checkSyntax;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder rmanScript(RMANScript rmanScript) {
            this.rmanScript = rmanScript;
            return this;
        }

        public Builder catalogScript(String catalogScript) {
            this.catalogScript = catalogScript;
            return this;
        }

        public Builder tnsAdmin(String tnsAdmin) {
            this.tnsAdmin = tnsAdmin;
            return this;
        }

        public Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder traceFile(String traceFile) {
            this.traceFile = traceFile;
            return this;
        }

        public Builder oracleSid(String oracleSid) {
            this.oracleSid = oracleSid;
            return this;
        }

        public Builder oracleHome(String oracleHome) {
            this.oracleHome = oracleHome;
            return this;
        }

        public RMANCommand build() {
            if (this.oracleHome == null) {
                return new RMANCommand(this);
            }
            return new RMANCommand(this, this.oracleHome);
        }
    }
}

