/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.rcvconf;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import oracle.dbtools.extension.rcv.models.rcvconf.Actions;
import oracle.dbtools.extension.rcv.models.rcvconf.CurrentState;
import oracle.dbtools.extension.rcv.models.rcvconf.Phase;
import oracle.dbtools.extension.rcv.utils.Utils;

public class RcvConf {
    private static final String SCHEMA = "schema";
    private static final String VERSION = "version";
    private static final String PHASE = "phase";
    private static final String CURRENT_STATE = "currentState";
    private static final String ACTIONS = "actions";
    private String dbUniqueName;
    private String md5sum;
    private long lastModified;
    private int schema;
    private int version;
    private Phase phase;
    private Actions actions;
    private CurrentState currentState;

    public static RcvConf load(String rcvConfFile, String dbUniqueName) throws IOException {
        File f = new File(rcvConfFile);
        RcvConf rcvConf = new RcvConf();
        rcvConf.dbUniqueName = dbUniqueName;
        try (FileInputStream fileStream = new FileInputStream(f);
             JsonReader jsonReader = Json.createReader((InputStream)fileStream);){
            JsonObject jsonObject = jsonReader.readObject();
            rcvConf.lastModified = f.lastModified();
            try {
                rcvConf.md5sum = Utils.getMD5Sum(rcvConfFile);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            if (jsonObject.containsKey((Object)SCHEMA)) {
                rcvConf.schema = jsonObject.getInt(SCHEMA);
            }
            if (jsonObject.containsKey((Object)VERSION)) {
                rcvConf.version = jsonObject.getInt(VERSION);
            }
            if (jsonObject.containsKey((Object)PHASE)) {
                rcvConf.phase = Phase.toPhase(jsonObject.getString(PHASE));
            }
            if (jsonObject.containsKey((Object)CURRENT_STATE)) {
                rcvConf.currentState = CurrentState.getCurrentState(jsonObject.getJsonObject(CURRENT_STATE), dbUniqueName);
            }
            if (jsonObject.containsKey((Object)ACTIONS)) {
                rcvConf.actions = Actions.getActions(jsonObject.getJsonObject(ACTIONS), dbUniqueName);
            }
        }
        return rcvConf;
    }

    public int getSchema() {
        return this.schema;
    }

    public int getVersion() {
        return this.version;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public Actions getActions() {
        return this.actions;
    }

    public CurrentState getCurrentState() {
        return this.currentState;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

