/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.database;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;

public class Oratab {
    public static List<OratabEntry> get() {
        String[] oratabFiles;
        for (String f : oratabFiles = new String[]{"/etc/oratab", "/var/opt/oracle/oratab"}) {
            List<OratabEntry> entries;
            if (!Files.exists(Path.of(f, new String[0]), new LinkOption[0]) || (entries = Oratab.get(f)).isEmpty()) continue;
            return entries;
        }
        return new ArrayList<OratabEntry>();
    }

    public static List<OratabEntry> get(String oratabPath) {
        ArrayList<OratabEntry> entries = new ArrayList<OratabEntry>();
        try (BufferedReader reader = new BufferedReader(new FileReader(oratabPath));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("#") || (parts = trimmedLine.split(":")).length != 3) continue;
                entries.add(new OratabEntry(parts[0], parts[1]));
            }
        }
        catch (IOException e) {
            RCVCommandBase.getLogger().getLogger().log(Level.INFO, "Failed to read " + oratabPath, e);
        }
        return entries;
    }

    public static Optional<String> getOracleHome(String dbUniqueName, String oracleSid) {
        List<OratabEntry> oratabEntries = Oratab.get();
        for (OratabEntry entry : oratabEntries) {
            if (!entry.getOracleSid().equalsIgnoreCase(oracleSid)) continue;
            return Optional.of(entry.getOracleHome());
        }
        return Optional.empty();
    }

    public static class OratabEntry {
        private String oracleSid;
        private String oracleHome;

        private OratabEntry(String oracleSid, String oracleHome) {
            this.oracleSid = oracleSid;
            this.oracleHome = oracleHome;
        }

        public String getOracleHome() {
            return this.oracleHome;
        }

        public String getOracleSid() {
            return this.oracleSid;
        }
    }
}

