/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.workflows.Result;

public class NextActionRequest
extends FleetEngineRequest {
    private int sessionId;
    private static final String NEXT_ACTION = "call dbms_ra_cmd_engine.next_action(?, ?, ?, ?)";

    private NextActionRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        this.getLogger().log(Level.FINE, "DbUniqueName: " + dbUniqueName.toUpperCase());
        this.getLogger().log(Level.FINE, "sessionId     : " + builder.sessionId);
        try {
            CallableStatement cs = super.getCallableStatement();
            cs.setInt("SESSION_ID", builder.sessionId);
            cs.registerOutParameter("ACTION_ID_OUT", 4);
            cs.registerOutParameter("STATUS_CODE_OUT", 4);
            cs.registerOutParameter("STATUS_MESG_OUT", 12);
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_NEXT_ACTION_ERROR_MSG", new Object[0]), e);
        }
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public FleetEngineResponse<Integer> execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int actionId = cs.getInt("ACTION_ID_OUT");
        int statusCode = cs.getInt("STATUS_CODE_OUT");
        String statusMessage = cs.getString("STATUS_MESG_OUT");
        this.getLogger().log(Level.FINE, "StatusCode   : " + statusCode);
        this.getLogger().log(Level.FINE, "ActionId     : " + actionId);
        this.getLogger().log(Level.FINE, "StatusMessage: " + statusMessage);
        return new FleetEngineResponse<Integer>(statusCode, statusMessage, Integer.valueOf(actionId));
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int sessionId;

        public Builder(Connection conn, String dbUniqueName, int sessionId, Logger logger) {
            super(conn, dbUniqueName, NextActionRequest.NEXT_ACTION, logger);
            this.sessionId = sessionId;
        }

        @Override
        public NextActionRequest build() {
            return new NextActionRequest(this);
        }

        public Builder logger(Logger logger) {
            super.setLogger(logger);
            return this;
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

