/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.workflows.Result;

public abstract class FleetEngineRequest {
    private Connection conn;
    private String dbUniqueName;
    private CallableStatement cs;
    private Logger logger;

    protected FleetEngineRequest(Builder<?> builder) {
        this.conn = builder.conn;
        this.dbUniqueName = builder.dbUniqueName;
        this.logger = builder.logger;
        try {
            this.cs = this.conn.prepareCall(builder.plsqlCall);
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_PREPARE_STMT_ERROR_MSG", new Object[0]), e);
        }
    }

    public Connection getFleetEngineConnection() {
        return this.conn;
    }

    public CallableStatement getCallableStatement() {
        return this.cs;
    }

    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public abstract <R> FleetEngineResponse<R> execute() throws SQLException;

    public static abstract class Builder<T extends Builder<T>> {
        private Connection conn;
        private String dbUniqueName;
        private String plsqlCall;
        private Logger logger;

        public Builder(Connection conn, String dbUniqueName, String plsqlCall, Logger logger) {
            this.conn = conn;
            this.dbUniqueName = dbUniqueName;
            this.plsqlCall = plsqlCall;
            this.logger = logger;
        }

        protected void setLogger(Logger logger) {
            this.logger = logger;
        }

        public abstract FleetEngineRequest build();

        public abstract T self();
    }
}

