/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models;

public class WalletEntry {
    private String id;
    private String username;
    private char[] password;
    private String credentialAlias;

    private WalletEntry(Builder builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.password = builder.password;
        this.credentialAlias = builder.credentialAlias;
    }

    public String getUserName() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getCredentialAlias() {
        return this.credentialAlias;
    }

    public static class Builder {
        private String id;
        private String username;
        private char[] password;
        private String credentialAlias;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(char[] password) {
            this.password = password;
            return this;
        }

        public Builder credentialAlias(String alias) {
            this.credentialAlias = alias;
            return this;
        }

        public WalletEntry build() {
            return new WalletEntry(this);
        }
    }
}

