/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogCleaner {
    public static void cleanLogFiles(String logDirectory, String prefix, int numFilesToKeep) {
        File dir = new File(logDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] logFiles = dir.listFiles((d, name) -> name.startsWith(prefix) && (name.endsWith(".log") || name.endsWith(".log.lck")));
        if (logFiles == null) {
            return;
        }
        Arrays.sort(logFiles, Comparator.comparingLong(File::lastModified));
        int numFilesToDelete = logFiles.length - numFilesToKeep;
        if (numFilesToDelete > 0) {
            for (int i = 0; i < numFilesToDelete; ++i) {
                File logFile = logFiles[i];
                logFile.delete();
            }
        }
    }

    public static void compressLogs(String logDirectory, String prefix, int numFilesToKeepUncompressed, String zipName) throws IOException {
        LogCleaner.compressLogs(logDirectory, prefix, "log", numFilesToKeepUncompressed, zipName);
    }

    public static void compressLogs(String logDirectory, String prefix, String fileExtension, int numFilesToKeepUncompressed, String zipName) throws IOException {
        File dir = new File(logDirectory);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] logFiles = dir.listFiles((d, name) -> name.startsWith(prefix) && (name.endsWith("." + fileExtension) || name.endsWith("." + fileExtension + ".lck")));
        if (logFiles == null) {
            return;
        }
        Arrays.sort(logFiles, Comparator.comparingLong(File::lastModified));
        int numFilesToCompress = logFiles.length - numFilesToKeepUncompressed;
        if (numFilesToCompress > 0) {
            File zipFile = new File(zipName);
            try (FileOutputStream fos = new FileOutputStream(zipFile);
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                for (int i = 0; i < numFilesToCompress; ++i) {
                    File fileToCompress = logFiles[i];
                    if (!fileToCompress.exists() || fileToCompress.isDirectory()) continue;
                    ZipEntry zipEntry = new ZipEntry(fileToCompress.toString());
                    zos.putNextEntry(zipEntry);
                    try (FileInputStream fis = new FileInputStream(fileToCompress);){
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                    }
                    zos.closeEntry();
                }
            }
            for (int i = 0; i < numFilesToCompress; ++i) {
                logFiles[i].delete();
            }
        }
    }
}

