/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.transformers;

import com.oracle.bmc.recovery.model.RecoveryServiceSubnetSummary;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.OCIDatabaseRecoveryClient;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.StringList;
import oracle.dbtools.util.Logger;

public class RecoverySubnetList
extends StringList {
    public List<String> transform(String rawValue, TransformContext context, Environment environment) {
        List elements = super.transform(rawValue, context, environment);
        ScriptRunnerContext ctx = environment.getCtx();
        String profileName = ctx.getStringProperty("oci.profile.name", null);
        String region = environment.getCtx().getStringProperty("oci.region.name", null);
        try {
            if (profileName != null) {
                OCIAuthentication authentication = GlobalMetadata.load().getAuthentication();
                OCIProfiles profiles = OCIProfiles.builder().configPath(authentication.getConfigFile()).build();
                OCIProfile profile = profiles.getProfile(authentication.getProfileName());
                OCIDatabaseRecoveryClient.Builder builder = OCIDatabaseRecoveryClient.builder(profile);
                if (region != null) {
                    builder.region(region);
                }
                OCIDatabaseRecoveryClient client = builder.build();
                String compartmentId = ctx.getStringProperty("oci.recoverySubnet.compartment", null);
                return client.listRecoverySubnets(compartmentId != null ? compartmentId : profile.getTenantId()).stream().filter(s -> elements.contains(s.getDisplayName())).map(RecoveryServiceSubnetSummary::getId).collect(Collectors.toUnmodifiableList());
            }
        }
        catch (IOException e) {
            Logger.warn(((Object)((Object)this)).getClass(), (String)e.getMessage(), (Throwable)e);
        }
        return elements;
    }
}

